% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading-animations.R
\name{progression_calculator}
\alias{progression_calculator}
\alias{render.progression_calculator}
\title{Creates a progression calculator which can display a loading bar and expected time to completion}
\usage{
progression_calculator(task_description, N)

\method{render}{progression_calculator}(object, i, interval = 10, ...)
}
\arguments{
\item{task_description}{A description of the task which is executed, if set to NA then no description if printed when using the render() function}

\item{N}{The number of steps that are needed to complete the task}

\item{object}{A progression calculator}

\item{i}{The current iteration.}

\item{interval}{The number of iterations to be completed before the progression calculator is updated.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Creates a progression calculator which can display a loading bar and expected time to completion
}
\examples{
\dontrun{
#create progression calculator with 10 iterations
progress = progression_calculator("Example", N=10)
for(i in 1:10) {
  render(progress, i, interval=1) #render the calculator
  Sys.sleep(0.2)
}
}
}
