% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_index.R
\name{hexify_lonlat_to_cell}
\alias{hexify_lonlat_to_cell}
\title{Convert longitude/latitude to cell ID}
\usage{
hexify_lonlat_to_cell(lon, lat, resolution, aperture)
}
\arguments{
\item{lon}{Numeric vector of longitudes in degrees}

\item{lat}{Numeric vector of latitudes in degrees}

\item{resolution}{Grid resolution (integer >= 0)}

\item{aperture}{Grid aperture (3, 4, or 7)}
}
\value{
Numeric vector of cell IDs (1-based)
}
\description{
Converts geographic coordinates to DGGRID-compatible cell identifiers.
This is the primary function for geocoding points to grid cells.
}
\details{
Returns DGGRID-compatible cell identifiers. The cell ID
uniquely identifies each hexagonal cell in the global grid.

For a grid-object interface, use \code{\link{lonlat_to_cell}}.
}
\examples{
cell_id <- hexify_lonlat_to_cell(0, 45, resolution = 5, aperture = 3)
}
\seealso{
\code{\link{lonlat_to_cell}} for the recommended S4 interface,
\code{\link{hexify_cell_to_lonlat}} for the inverse operation

Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
