% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_pair_apply.R
\name{correctGreater}
\alias{correctGreater}
\title{Creates function indicating whether row1[col] > row2[col].}
\usage{
correctGreater(criterion_col, output_column_name = "CorrectGreater")
}
\arguments{
\item{criterion_col}{The integer index of the criterion in test_data.}

\item{output_column_name}{An optional string}
}
\value{
An object that implements createFunction.
  Users will generally not use this directly-- rowPairApply will.
}
\description{
Using rowPairApply, this can generate a column indicating the
the correct direction of the criterion in comparing row 1 vs. row2 for
all row pairs in test_data.
  1 indicates row 1's criterion > row 2's criterion
  0 indicates they are equal
 -1 indicaties row 2's criterion is greater
By default, the output column is called "CorrectGreater," but you
can override the name with output_column_name.
}
\details{
This is meant to be used to measure the performance of heuristics
wrapped with \code{\link{heuristics}}.
}
\seealso{
\code{\link{heuristics}} is the wrapper to get the predicted greater
  row in the row pair for each heuristic passed in to it.

\code{\link{rowPairApply}} which has an example of using this.
}
