% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetu_control_char.R
\name{satu_control_char}
\alias{satu_control_char}
\title{Finnish Unique Identification Number Control Character Calculator}
\usage{
satu_control_char(pin, print.full = FALSE)
}
\arguments{
\item{pin}{An incomplete FINUID that has 8 first numbers.}

\item{print.full}{Should the function print only the whole FINUID-number 
(TRUE) or only the control character (FALSE). Default is FALSE.}
}
\value{
Control character, either a number 0-9 or a letter (length 1 
   character). If parameter print.full is set to TRUE, the function returns
   a complete FINUID / SATU number (length 9 characters).
}
\description{
Calculate a valid control character for an incomplete
   Finnish Unique Identification Number (FINUID, or sähköinen asiointitunnus
   SATU).
}
\details{
This method of calculating the control character was devised by
   mathematician Erkki Pale (1962) to detect input errors but also to
   detect errors produced by early punch card machines. The long number
   produced by writing the birth date and the personal number together are
   divided by 31 and the remainder is used to look up the control character
   from a separate table containing alphanumeric characters except letters
   G, I, O, Q and Z.

   The method of calculating the control character does not need century
   character and therefore the function has an option to omit it.
}
\examples{
# The first assigned FINUID number, 10000001N.
satu_control_char("10000001")
}
\seealso{
For more detailed information about FINUID, see Finnish Digital and
population data services agency website:
\url{https://dvv.fi/en/citizen-certificate-and-electronic-identity}
}
\author{
Pyry Kantanen
}
