% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.numeric.R
\name{prepare.numeric}
\alias{prepare.numeric}
\title{Prepare data vector for sandwich smooth}
\usage{
\method{prepare}{numeric}(data, x, splines, m = 2, sparse = TRUE, ...)
}
\arguments{
\item{data}{A numeric data vector}

\item{x}{A sequence of equidistant values
corresponding to where the data
are observed.  Equidistant spacing between 0 and 1 is
assumed if not supplied.  See Details.}

\item{splines}{A spline-related object, e.g.,
produced by \code{\link{bspline}}.  A spline is
automatically created if not supplied.  See Details.}

\item{m}{A positive integer indicating order of the difference penalty.}

\item{sparse}{A logical value indicating if the result
should be a sparse version of the
\code{\link[Matrix]{Matrix-class}}.}

\item{...}{Not currently implemented.}
}
\value{
A \code{prepared_numeric} object.
}
\description{
\code{prepare.vector} prepares a data vector for the
sandwich smooth.  Unlike the other \code{prepare.*}
functions, \code{x} and \code{splines} do not
need to be lists since the data are 1-dimensional.
}
\details{
If \code{x} is not supplied and \code{n} is
the \code{length(data)}, then the function automatically
sets \code{x = seq(0, 1, length = n)}.

If \code{splines} is not supplied, and \code{n} is the
\code{length(data)}, then the function automatically sets
\code{splines = bspline(range(x), nknots = min(ceiling(n/4), 35))}.
}
\examples{
# create data
n = 160
x = seq(0, 4 * pi, len = n)
# "true" data
mu = sin(x)
# plot true data
plot(x, mu, type = "l")
# construct noisy data
set.seed(4)
data = mu + rnorm(n)

# construct spline
splines = bspline(c(0, 4 * pi), nknots = 20)
# prepare/enhance data
obj = prepare(data, x, splines)
obj = enhance(obj)
sandmod = hero(obj)
plot(sandmod, ylim = range(data), lty = 2)
lines(x, data, col = "lightgrey")
lines(x, mu)
legend("bottomleft",
       legend = c("smoothed", "true", "observed"),
       lty = c(2, 1, 1),
       col = c("black", "black", "grey"))
}
\references{
Xiao, L. , Li, Y. and Ruppert, D. (2013),
  Fast bivariate P-splines: the sandwich smoother. J. R.
  Stat. Soc. B, 75: 577-599. <doi:10.1111/rssb.12007>

  Ruppert, D., Wand, M. P., & Carroll, R. J. (2003).
  Semiparametric Regression. Cambridge University Press.
  <doi:10.1017/CBO9780511755453>
}
\seealso{
\code{\link{bspline}},
  \code{\link{default.evalargs}},
  \code{\link{default.splines}}
}
\author{
Joshua French.  Based off code by Luo Xiao (see
  References).
}
