% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{hermite_integral_val}
\alias{hermite_integral_val}
\title{Outputs a definite integral of the orthonormal Hermite functions}
\usage{
hermite_integral_val(N, x, hermite_function_mat)
}
\arguments{
\item{N}{An integer number.}

\item{x}{A numeric vector.}

\item{hermite_function_mat}{A numeric matrix of Hermite function values 
generated by the function hermite_function.}
}
\value{
A numeric matrix with N+1 rows and length(x) columns.
}
\description{
The method calculates \eqn{\int_{-\infty}^{x} h_k(t) dt} 
for \eqn{k=0,\dots,N} and the vector of values x.
}
\author{
Michael Stephanou <michael.stephanou@gmail.com>
}
