% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defunct.R
\name{traffic-defunct}
\alias{traffic-defunct}
\title{HERE Traffic API: Flow and Incidents}
\usage{
traffic(aoi,
  product = "flow", from = NULL, to = NULL,
  min_jam_factor = 0, url_only = FALSE
)
}
\arguments{
\item{aoi}{\code{sf} object, Areas of Interest (POIs) of geometry type \code{POLYGON}.}

\item{product}{character, traffic product of the 'Traffic API'. Supported products: \code{"flow"} and \code{"incidents"}.}

\item{from}{\code{POSIXct} object, datetime of the earliest traffic incidents (Note: Only takes effect if \code{product} is set to \code{"incidents"}).}

\item{to}{\code{POSIXct} object, datetime of the latest traffic incidents (Note: Only takes effect if \code{product} is set to \code{"incidents"}).}

\item{min_jam_factor}{numeric, only retrieve flow information with a jam factor greater than the value provided (Note: Only takes effect if \code{product} is set to \code{"flow"}, \code{default = 0}).}

\item{url_only}{boolean, only return the generated URLs (\code{default = FALSE})?}
}
\value{
An \code{sf} object containing the requested traffic information.
}
\description{
Real-time traffic flow and incident information based on the HERE 'Traffic' API in areas of interest (AOIs).
The traffic flow data contains speed (\code{"SP"}) and congestion (jam factor: \code{"JF"}) information.
Traffic incidents contain information about location, time, duration, severity, description and other details.
}
\references{
\itemize{
  \item\href{https://developer.here.com/api-explorer/rest/traffic}{HERE Traffic API}
  \item\href{https://stackoverflow.com/questions/28476762/reading-traffic-flow-data-from-here-maps-rest-api}{Flow explanation, stackoverflow}
}
}
\seealso{
\code{\link{hereR-defunct}}
}
\keyword{internal}
