% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gapfrac_fisheye.R
\name{gapfrac_fisheye}
\alias{gapfrac_fisheye}
\alias{list.lenses}
\title{Derive angular gap fraction from a classified fisheye image}
\usage{
gapfrac_fisheye(
  img.bw,
  maxVZA = 90,
  lens = "equidistant",
  startVZA = 0,
  endVZA = 70,
  nrings = 7,
  nseg = 8,
  message = FALSE,
  display = FALSE
)
}
\arguments{
\item{img.bw}{SpatLayer. A binary, single-layer fisheye image generated from \code{\link[=binarize_fisheye]{binarize_fisheye()}}.}

\item{maxVZA}{Numeric. The maximum Zenith angle (in degrees) corresponding to the image radius. Default= 90.}

\item{lens}{Character. The lens type for fisheye-lens correction. A list of lenses is available by typing \emph{list.lenses}. If missing, it is assumed equidistant.}

\item{startVZA}{Numeric. The minimum Zenith angle (in degrees) considered in the analysis. Default is 0.}

\item{endVZA}{Numeric. The maximum Zenith angle (in degrees) considered in the analysis. Default is 70.}

\item{nrings}{Numeric. The number of equiangular zenith rings considered in the analysis. Default is 7.}

\item{nseg}{Numeric. The number of azimuth segments considered in the analysis. Default is 8.}

\item{message}{Logical. If set to TRUE, it reports the circular mask used in the analysis.}

\item{display}{Logical. If set to TRUE, it desplays the zenith rings and azimuth segments overlaid on the fisheye image.}
}
\value{
A dataframe of gap fraction (GF) for zenith rings (rows) and azimuth segments (columns).
}
\description{
The function calculates the gap fraction for a number of zenith annuli (rings) and azimuth sectors (segments).
A list of lens is available for correcting for lens distorsion. Type 'list.lenses'.
}
\examples{
\donttest{c.im<-system.file('extdata/circular_coolpix4500+FC-E8_chestnut.jpg',package='hemispheR')

#List of lenses for fisheye projection correction:
list.lenses

#Zenith rings similar to LAI-2000/2200:
c.im |>
 import_fisheye(circ.mask=camera_fisheye('Coolpix4500+FC-E8')) |>
  binarize_fisheye() |>
  gapfrac_fisheye(lens='FC-E8',nrings=5,nseg=8,endVZA=75,display=TRUE)

#The hinge angle method close to 1 radian (57):
c.im |>
 import_fisheye(circ.mask=camera_fisheye('Coolpix4500+FC-E8')) |>
  binarize_fisheye() |>
  gapfrac_fisheye(lens='FC-E8',nrings=1,nseg=8,startVZA=55,endVZA=60,display=TRUE)
}


}
\seealso{
Lens correction functions have been retrieved from the following sources:

Pekin and Macfarlane 2009: \doi{10.3390/rs1041298}

Paul Bourke:\url{http://www.paulbourke.net/dome/fisheyecorrect/}

Hemisfer: \url{https://www.schleppi.ch/patrick/hemisfer/index.php}
}
\author{
Francesco Chianucci
}
