% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update-model}
\alias{plot.updated_models}
\alias{update-model}
\alias{update.run_models}
\title{Run Model on New Data}
\usage{
\method{update}{run_models}(object, newdata, ...)

\method{plot}{updated_models}(x, model, type = c("cost", "effect", "icer",
  "counts", "ce"), ...)
}
\arguments{
\item{object}{The result of \code{\link{run_models}}.}

\item{newdata}{A \code{data.frame} of new parameter sets,
one column per parameter and one row per parameter set.
An optional \code{.weights} column can be included for
a weighted analysis.}

\item{...}{Additional arguments passed to
\code{geom_histogram}. Especially usefull to specify
\code{binwidth}.}

\item{x}{Updated model to plot.}

\item{model}{A model index, character or numeric.}

\item{type}{The type of plot to return (see details).}
}
\value{
A \code{data.frame} with one row per model/value.
}
\description{
Given a table of new parameter values with a new 
parameter set per line, runs iteratively Markov models 
over these sets.
}
\details{
\code{newdata} must be a \code{data.frame} with the
following properties: the column names must be parameter 
names used in \code{\link{define_parameters}}; and an
optional column \code{.weights} can give the respective
weight of each row in the target population.

Weights are automatillcally scaled. If no weights are
provided equal weights are used for each strata.

For the plotting function, the \code{type} argument can
take the following values: \code{"cost"}, \code{"effect"}
or \code{"icer"} to plot the heterogeneity of the
respective values. Furthermore \code{"ce"} and
\code{"count"} can produce from the combined model plots
similar to those of \code{\link{run_models}}.
}
\section{Warning}{

  
  Histograms do not account for weights. On the other
  hand summary results do.
}
\examples{
mod1 <-
  define_model(
    transition_matrix = define_matrix(
      .5, .5,
      .1, .9
    ),
    define_state(
      cost = 543 + age * 5,
      ly = 1
    ),
    define_state(
      cost = 432 + age,
      ly = 1 * age / 100
    )
  )

mod2 <-
  define_model(
    transition_matrix = define_matrix(
      .5, .5,
      .1, .9
    ),
    define_state(
      cost = 789 * age / 10,
      ly = 1
    ),
    define_state(
      cost = 456 * age / 10,
      ly = 1 * age / 200
    )
  )

res <- run_models(
  mod1, mod2,
  parameters = define_parameters(
    age_init = 60,
    age = age_init + markov_cycle
  ),
  init = 1:0,
  cycles = 10,
  cost = cost,
  effect = ly
)

# generating table with new parameter sets
new_tab <- data.frame(
  age_init = 40:80
)

# with run_model result
ndt <- update(res, newdata = new_tab)

summary(ndt)

# using weights

new_tab2 <- data.frame(
  age_init = 40:80,
  .weights = runif(41)
)
ndt2 <- update(res, newdata = new_tab2)

summary(ndt2)
}

