% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src_summaries.R
\name{plot_beta}
\alias{plot_beta}
\title{Plot posterior distribution of beta for each context}
\usage{
plot_beta(
  samples,
  X = NULL,
  context.id = NULL,
  true.beta = NULL,
  title = NULL,
  subtitle = NULL,
  plot.mean = FALSE,
  plot.grid = FALSE,
  showKhat = FALSE,
  col = NULL,
  xlab.size = NULL,
  ylab.size = NULL,
  title.size = NULL,
  legend.size = NULL,
  xtick.distance = NULL,
  left.margin = 0,
  ytick.distance = NULL,
  col.border = "white"
)
}
\arguments{
\item{samples}{an output of the function \code{\link{hdpGLM}}}

\item{X}{a string vector with the name of the first-level covariates whose associated tau should be displayed}

\item{context.id}{string with the name of the column containing the labels identifying the contexts. This variable should have been specified when the estimation was conducted using the function \code{\link{hdpGLM}}.}

\item{true.beta}{a \code{data.frame} with the true values of the linear coefficients \code{beta} if they are known. The \code{data.frame} must contain a column named \code{j} with the index of the context associated with that particular linear coefficient \code{beta}. It must match the indexes used in the data set for each context. Another column named \code{k} must be provided, indicating the cluster of \code{beta}, and a column named \code{Parameter} with the name of the linear coefficients (\code{beta1}, \code{beta2}, ..., \code{beta_dx}, where \code{dx} is the number of covariates at the individual level, and beta1 is the coefficient of the intercept term). It must contain a column named \code{True} with the true value of the \code{betas}. Finally, the \code{data.frame} must contain columns with the context-level covariates as used in the estimation of the \link{hdpGLM} function (see Details below).}

\item{title}{string, title of the plot}

\item{subtitle}{string, the subtitle of the plot}

\item{plot.mean}{boolean, if \code{TRUE} the posterior mean of every cluster is displayed}

\item{plot.grid}{boolean, if \code{TRUE} a grid is displayed in the background}

\item{showKhat}{boolean, if \code{TRUE} a message with the number of estimated clusters by context is displayed}

\item{col}{string, color of the densities}

\item{xlab.size}{numeric, size of the breaks in the x-axis}

\item{ylab.size}{numeric, size of the breaks in the y-axis}

\item{title.size}{numeric, size of the title}

\item{legend.size}{numeric, size of the legend}

\item{xtick.distance}{numeric, distance between x-axis marks and bottom of the figure}

\item{left.margin}{numeric, distance between left margin and left side of the figure}

\item{ytick.distance}{numeric, distance between y-axis marks and bottom of the figure}

\item{col.border}{string, color of the border of the densities}
}
\description{
Plot the posterior distribution of the linear parameters beta for each context
}
