% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hdnom.models.R
\name{hdcox.aenet}
\alias{hdcox.aenet}
\title{Adaptive elastic-net model selection for high-dimensional Cox models}
\usage{
hdcox.aenet(x, y, nfolds = 5L, alphas = seq(0.05, 0.95, 0.05),
  rule = c("lambda.min", "lambda.1se"), seeds = c(1001, 1002),
  parallel = FALSE)
}
\arguments{
\item{x}{Data matrix.}

\item{y}{Response matrix made with \code{\link[survival]{Surv}}.}

\item{nfolds}{Fold numbers of cross-validation.}

\item{alphas}{Alphas to tune in \code{\link[glmnet]{cv.glmnet}}.}

\item{rule}{Model selection criterion, \code{"lambda.min"} or
\code{"lambda.1se"}. See \code{\link[glmnet]{cv.glmnet}}
for details.}

\item{seeds}{Two random seeds for cross-validation fold division
in two estimation steps.}

\item{parallel}{Logical. Enable parallel parameter tuning or not,
default is {FALSE}. To enable parallel tuning, load the
\code{doParallel} package and run \code{registerDoParallel()}
with the number of CPU cores before calling this function.}
}
\description{
Automatic adaptive elastic-net model selection for high-dimensional
Cox models, evaluated by penalized partial-likelihood.
}
\examples{
library("glmnet")
library("survival")
library("rms")

# Load imputed SMART data
data("smart")
x = as.matrix(smart[, -c(1, 2)])
time = smart$TEVENT
event = smart$EVENT
y = Surv(time, event)

# To enable parallel parameter tuning, first run:
# library("doParallel")
# registerDoParallel(detectCores())
# then set hdcox.aenet(..., parallel = TRUE).

# Fit Cox model by adaptive elastic-net penalization
aenetfit = hdcox.aenet(x, y, nfolds = 3, alphas = c(0.3, 0.7),
                       rule = "lambda.1se", seeds = c(5, 7))

# Prepare data for hdnom.nomogram
x.df = as.data.frame(x)
dd = datadist(x.df)
options(datadist = "dd")

# Generate hdnom.nomogram objects and plot nomogram
nom = hdnom.nomogram(aenetfit$aenet_model, x, time, event, x.df,
                     lambda = aenetfit$aenet_best_lambda, pred.at = 365 * 2,
                     funlabel = "2-Year Overall Survival Probability")

plot(nom)
}

