/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#ifndef H5FDsubfiling_H
#define H5FDsubfiling_H
#ifdef H5_HAVE_SUBFILING_VFD
#define H5FD_SUBFILING (H5FDperform_init(H5FD_subfiling_init))
#else
#define H5FD_SUBFILING (H5I_INVALID_HID)
#endif
#define H5FD_SUBFILING_NAME "subfiling"
#ifdef H5_HAVE_SUBFILING_VFD
#ifndef H5FD_SUBFILING_FAPL_MAGIC
#define H5FD_SUBFILING_CURR_FAPL_VERSION 1
#define H5FD_SUBFILING_FAPL_MAGIC 0xFED01331
#endif
#define H5FD_SUBFILING_DEFAULT_STRIPE_SIZE (32 * 1024 * 1024)
#define H5FD_SUBFILING_DEFAULT_STRIPE_COUNT -1
#define H5FD_SUBFILING_FILENAME_TEMPLATE "%s.subfile_%" PRIu64 "_%0*d_of_%d"
#define H5FD_SUBFILING_CONFIG_FILENAME_TEMPLATE "%s.subfile_%" PRIu64 ".config"
#define H5FD_SUBFILING_STRIPE_SIZE "H5FD_SUBFILING_STRIPE_SIZE"
#define H5FD_SUBFILING_IOC_PER_NODE "H5FD_SUBFILING_IOC_PER_NODE"
#define H5FD_SUBFILING_IOC_SELECTION_CRITERIA "H5FD_SUBFILING_IOC_SELECTION_CRITERIA"
#define H5FD_SUBFILING_SUBFILE_PREFIX "H5FD_SUBFILING_SUBFILE_PREFIX"
#define H5FD_SUBFILING_CONFIG_FILE_PREFIX "H5FD_SUBFILING_CONFIG_FILE_PREFIX"
typedef enum {
    SELECT_IOC_ONE_PER_NODE = 0,
    SELECT_IOC_EVERY_NTH_RANK,
    SELECT_IOC_WITH_CONFIG,
    SELECT_IOC_TOTAL,
    ioc_selection_options
} H5FD_subfiling_ioc_select_t;
typedef struct H5FD_subfiling_params_t {
    H5FD_subfiling_ioc_select_t ioc_selection;
    int64_t                     stripe_size;
    int32_t                     stripe_count;
} H5FD_subfiling_params_t;
//! <!-- [H5FD_subfiling_config_t_snip] -->
typedef struct H5FD_subfiling_config_t {
    uint32_t magic;
    uint32_t version;
    hid_t    ioc_fapl_id;
    bool     require_ioc;
    H5FD_subfiling_params_t shared_cfg;
} H5FD_subfiling_config_t;
//! <!-- [H5FD_subfiling_config_t_snip] -->
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL hid_t H5FD_subfiling_init(void);
H5_DLL herr_t H5Pset_fapl_subfiling(hid_t fapl_id, const H5FD_subfiling_config_t *vfd_config);
H5_DLL herr_t H5Pget_fapl_subfiling(hid_t fapl_id, H5FD_subfiling_config_t *config_out);
#ifdef __cplusplus
}
#endif
#endif
#endif
