// (c) The HDF Group
#ifndef H5TSprivate_H_
#define H5TSprivate_H_
#ifdef H5_HAVE_THREADSAFE
#include "H5TSdevelop.h"
#ifdef H5_HAVE_WIN_THREADS
typedef struct H5TS_mutex_struct {
    CRITICAL_SECTION CriticalSection;
} H5TS_mutex_t;
typedef CRITICAL_SECTION H5TS_mutex_simple_t;
typedef HANDLE           H5TS_thread_t;
typedef HANDLE           H5TS_attr_t;
typedef DWORD            H5TS_key_t;
typedef INIT_ONCE        H5TS_once_t;
#define H5TS_SCOPE_SYSTEM  0
#define H5TS_SCOPE_PROCESS 0
#define H5TS_CALL_CONV     WINAPI
#define H5TS_get_thread_local_value(key)        TlsGetValue(key)
#define H5TS_set_thread_local_value(key, value) TlsSetValue(key, value)
#define H5TS_attr_init(attr_ptr)                0
#define H5TS_attr_setscope(attr_ptr, scope)     0
#define H5TS_attr_destroy(attr_ptr)             0
#define H5TS_wait_for_thread(thread)            WaitForSingleObject(thread, INFINITE)
#define H5TS_mutex_init(mutex)                  InitializeCriticalSection(mutex)
#define H5TS_mutex_lock_simple(mutex)           EnterCriticalSection(mutex)
#define H5TS_mutex_unlock_simple(mutex)         LeaveCriticalSection(mutex)
H5_DLL BOOL CALLBACK H5TS_win32_process_enter(PINIT_ONCE InitOnce, PVOID Parameter, PVOID *lpContex);
H5_DLL void          H5TS_win32_process_exit(void);
H5_DLL herr_t        H5TS_win32_thread_enter(void);
H5_DLL herr_t        H5TS_win32_thread_exit(void);
#define H5TS_thread_id() ((uint64_t)GetCurrentThreadId())
#else
typedef struct H5TS_mutex_struct {
    pthread_t       owner_thread;
    pthread_mutex_t atomic_lock;
    pthread_cond_t  cond_var;
    unsigned int    lock_count;
    pthread_mutex_t atomic_lock2;
    unsigned int    attempt_lock_count;
} H5TS_mutex_t;
typedef pthread_t       H5TS_thread_t;
typedef pthread_attr_t  H5TS_attr_t;
typedef pthread_mutex_t H5TS_mutex_simple_t;
typedef pthread_key_t   H5TS_key_t;
typedef pthread_once_t  H5TS_once_t;
#define H5TS_SCOPE_SYSTEM                       PTHREAD_SCOPE_SYSTEM
#define H5TS_SCOPE_PROCESS                      PTHREAD_SCOPE_PROCESS
#define H5TS_CALL_CONV
#define H5TS_get_thread_local_value(key)        pthread_getspecific(key)
#define H5TS_set_thread_local_value(key, value) pthread_setspecific(key, value)
#define H5TS_attr_init(attr_ptr)                pthread_attr_init((attr_ptr))
#define H5TS_attr_setscope(attr_ptr, scope)     pthread_attr_setscope(attr_ptr, scope)
#define H5TS_attr_destroy(attr_ptr)             pthread_attr_destroy(attr_ptr)
#define H5TS_wait_for_thread(thread)            pthread_join(thread, NULL)
#define H5TS_mutex_init(mutex)                  pthread_mutex_init(mutex, NULL)
#define H5TS_mutex_lock_simple(mutex)           pthread_mutex_lock(mutex)
#define H5TS_mutex_unlock_simple(mutex)         pthread_mutex_unlock(mutex)
H5_DLL uint64_t H5TS_thread_id(void);
H5_DLL void     H5TS_pthread_first_thread_init(void);
#endif
extern H5TS_once_t H5TS_first_init_g;
extern H5TS_key_t  H5TS_errstk_key_g;
#ifdef H5_HAVE_CODESTACK
extern H5TS_key_t H5TS_funcstk_key_g;
#endif
extern H5TS_key_t H5TS_apictx_key_g;
H5_DLL herr_t H5TS_mutex_lock(H5TS_mutex_t *mutex);
H5_DLL herr_t H5TS_mutex_unlock(H5TS_mutex_t *mutex);
H5_DLL herr_t H5TS_cancel_count_inc(void);
H5_DLL herr_t H5TS_cancel_count_dec(void);
H5_DLL H5TS_thread_t H5TS_create_thread(void *(*func)(void *), H5TS_attr_t *attr, void *udata);
#else
#define H5TS_thread_id() ((uint64_t)0)
#endif
#endif
