// (c) The HDF Group
#ifndef H5PLprivate_H
#define H5PLprivate_H
#include "H5PLpublic.h"
#include "H5private.h"
#include "H5FDprivate.h"
#include "H5VLprivate.h"
typedef struct H5PL_vol_key_t {
    H5VL_get_connector_kind_t kind;
    union {
        H5VL_class_value_t value;
        const char        *name;
    } u;
} H5PL_vol_key_t;
typedef struct H5PL_vfd_key_t {
    H5FD_get_driver_kind_t kind;
    union {
        H5FD_class_value_t value;
        const char        *name;
    } u;
} H5PL_vfd_key_t;
typedef union H5PL_key_t {
    int            id;
    H5PL_vol_key_t vol;
    H5PL_vfd_key_t vfd;
} H5PL_key_t;
typedef enum {
    H5PL_ITER_TYPE_FILTER,
    H5PL_ITER_TYPE_VOL,
    H5PL_ITER_TYPE_VFD,
    H5PL_ITER_TYPE_ALL,
} H5PL_iterate_type_t;
typedef herr_t (*H5PL_iterate_t)(H5PL_type_t plugin_type, const void *plugin_info, void *op_data);
H5_DLL const void *H5PL_load(H5PL_type_t plugin_type, const H5PL_key_t *key);
H5_DLL herr_t      H5PL_iterate(H5PL_iterate_type_t iter_type, H5PL_iterate_t iter_op, void *op_data);
H5_DLL herr_t      H5PL_init(void);
#endif
