% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{readfst}
\alias{readfst}
\title{Read fst or HDD files as DT}
\usage{
readfst(path, columns = NULL, from = 1, to = NULL, confirm = FALSE)
}
\arguments{
\item{path}{Path to \code{fst} file -- or path to \code{hdd} data. For hdd files, there is a}

\item{columns}{Column names to read. The default is to read all columns. Ignored for \code{hdd} files.}

\item{from}{Read data starting from this row number. Ignored for \code{hdd} files.}

\item{to}{Read data up until this row number. The default is to read to the last row of the stored data set. Ignored for \code{hdd} files.}

\item{confirm}{If the hdd file is larger than the variable \code{getHdd_extract.cap()}, then by default an error is raised. To anyway read the data, use \code{confirm = TRUE}. You can set the data cap with the function \code{\link[hdd]{setHdd_extract.cap}}, the default being 1GB.}
}
\description{
This is the function \code{\link[fst]{read_fst}} but with automatic conversion to data.table. It also allows to read \code{hdd} data.
}
\examples{

# Toy example with the iris data set

# writing a hdd file
hdd_path = tempfile()
write_hdd(iris, hdd_path, rowsPerChunk = 30)

# reading the full data in memory
base_mem = readfst(hdd_path)

# is equivalent to:
base_hdd = hdd(hdd_path)
base_mem_bis = base_hdd[]


}
\seealso{
See \code{\link[hdd]{hdd}}, \code{\link[hdd]{sub-.hdd}} and \code{\link[hdd]{cash-.hdd}} for the extraction and manipulation of out of memory data. For importation of HDD data sets from text files: see \code{\link[hdd]{txt2hdd}}.

See \code{\link[hdd]{hdd_slice}} to apply functions to chunks of data (and create HDD objects) and \code{\link[hdd]{hdd_merge}} to merge large files.

To create/reshape HDD objects from memory or from other HDD objects, see \code{\link[hdd]{write_hdd}}.

To display general information from HDD objects: \code{\link[hdd]{origin}}, \code{\link[hdd]{summary.hdd}}, \code{\link[hdd]{print.hdd}}, \code{\link[hdd]{dim.hdd}} and \code{\link[hdd]{names.hdd}}.
}
\author{
Laurent Berge
}
