% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUC.R
\name{AUC}
\alias{AUC}
\title{AUC for cure prediction using mean score imputation}
\usage{
AUC(object, newdata, cure_cutoff = 5, model.select = "AIC")
}
\arguments{
\item{object}{a \code{mixturecure} object resulting from \code{curegmifs}, \code{cureem}, \code{cv_curegmifs}, \code{cv_cureem}.}

\item{newdata}{an optional data.frame that minimally includes the incidence and/or latency variables to use for predicting the response. If omitted, the training data are used.}

\item{cure_cutoff}{cutoff value for cure, used to produce a proxy for the unobserved cure status; default is 5.}

\item{model.select}{for models fit using \code{curegmifs} or \code{cureem} any step along the solution path can be selected. The default is \code{model.select = "AIC"} which calculates the predicted values using the coefficients from the model having the lowest AIC. Other options are \code{model.select = "mAIC"} for the modified AIC,  \code{model.select = "cAIC"} for the corrected AIC, \code{model.select = "BIC"}, \code{model.select = "mBIC"} for the modified BIC, \code{model.select = "EBIC"} for the extended BIC, \code{model.select = "logLik"} for the step that maximizes the log-likelihood, or any numeric value from the solution path. This option has no effect for objects fit using \code{cv_curegmifs} or \code{cv_cureem}.}
}
\value{
Returns the AUC value for cure prediction using the mean score imputation (MSI) method.
}
\description{
This function calculates the AUC for cure prediction using the mean score imputation (MSI) method proposed by Asano et al.
}
\examples{
library(survival)
set.seed(1234)
temp <- generate_cure_data(N = 100, J = 10, nTrue = 10, A = 1.8)
training <- temp$Training
testing <- temp$Testing
fit <- curegmifs(Surv(Time, Censor) ~ .,
                  data = training, x.latency = training,
                  model = "weibull", thresh = 1e-4, maxit = 2000,
                  epsilon = 0.01, verbose = FALSE)
AUC(fit)
AUC(fit, newdata = testing)
}
\references{
Asano, J., Hirakawa, H., Hamada, C. (2014) Assessing the prediction accuracy of cure in the Cox proportional hazards cure model: an application to breast cancer data. \emph{Pharmaceutical Statistics}, \bold{13}:357--363.
}
\seealso{
\code{\link{concordance_mcm}}
}
\keyword{univar}
