% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_probs.R
\name{empirical_probs}
\alias{empirical_probs}
\title{Estimated transition probabilities}
\usage{
empirical_probs(X, S, matrixform = FALSE, A = NULL, warn = FALSE)
}
\arguments{
\item{X}{A vector or single-column data frame containing a sample of a Markov chain (\code{X[1]} is the most recent).}

\item{S}{A numeric vector of unique positive integers. Typically, \code{S} represents
a set of relevant lags.}

\item{matrixform}{Logical. If \code{TRUE}, the output is formatted as a stochastic
transition matrix.}

\item{A}{A numeric vector of distinct integers representing the state space.
If not provided, this function will set \code{A <- sort(unique(X))}.}

\item{warn}{Logical. If \code{TRUE}, the function warns the user when the state
space is automatically set as \code{A <- sort(unique(X))}.}
}
\value{
A data frame or a matrix containing estimated transition probabilities:
\itemize{
\item If \code{matrixform = FALSE}, the function returns a data frame with three columns:
\itemize{
\item The past sequence \eqn{x_S} (a concatenation of past states).
\item The current state \eqn{a}.
\item The estimated probability \eqn{\hat{p}(a | x_S)}.
}
\item If \code{matrixform = TRUE}, the function returns a stochastic transition matrix,
where rows correspond to past sequences \eqn{x_S} and columns correspond to states in \code{A}.
}
}
\description{
Computes the Maximum Likelihood estimators (MLE) for an MTD Markov chain with
relevant lag set \code{S}.
}
\details{
The probabilities are estimated as:
\deqn{\hat{p}(a | x_S) = \frac{N(x_S a)}{N(x_S)}}
where \eqn{N(x_S a)} is the number of times the sequence \eqn{x_S} appeared in the sample
followed by \eqn{a}, and \eqn{N(x_S)} is the number of times \eqn{x_S} appeared
(followed by any state). If \eqn{N(x_S) = 0}, the probability is set to \eqn{1 / |A|}
(assuming a uniform distribution over \code{A}).
}
\examples{
# Simulate a chain from an MTD model
set.seed(1)
M <- MTDmodel(Lambda = c(1, 15, 30), A = c(1, 2, 3), lam0 = 0.05)
X <- perfectSample(M, N = 400)

# Estimate probabilities for different subsets S
empirical_probs(X, S = c(1, 30))
empirical_probs(X, S = c(1, 15, 30), matrixform = TRUE)

}
