% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recompose.R
\name{recompose}
\alias{recompose}
\title{Recompose a data frame into another form}
\usage{
recompose(data, ..., composition = "tibble")
}
\arguments{
\item{data}{A data frame.}

\item{...}{These dots are for future extensions and must be empty.}

\item{composition}{One of:
\itemize{
\item \code{"tibble"} to convert to a tibble.
\item \code{"data.frame"} to convert to a base data frame.
\item \code{"matrix"} to convert to a matrix. All columns must be numeric.
\item \code{"dgCMatrix"} to convert to a sparse matrix. All columns must be numeric,
and the Matrix package must be installed.
}}
}
\value{
The output type is determined from the \code{composition}.
}
\description{
\code{recompose()} takes a data frame and converts it into one of:
\itemize{
\item A tibble
\item A data frame
\item A matrix
\item A sparse matrix (using the Matrix package)
}

This is an internal function used only by hardhat and recipes.
}
\examples{
df <- vctrs::data_frame(x = 1)

recompose(df)
recompose(df, composition = "matrix")

# All columns must be numeric to convert to a matrix
df <- vctrs::data_frame(x = 1, y = "a")
try(recompose(df, composition = "matrix"))
}
\keyword{internal}
