% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_cf_ets.R
\name{hcp_cf_ets}
\alias{hcp_cf_ets}
\title{Change Finder using ETS}
\usage{
hcp_cf_ets(sw_size = 7)
}
\arguments{
\item{sw_size}{Sliding window size}
}
\value{
\code{hcp_cf_ets} object
}
\description{
Change-point detection is related to event/trend change detection. Change Finder ETS detects change points based on deviations relative to trend component (T), a seasonal component (S), and an error term (E) model \url{doi:10.1109/TKDE.2006.1599387}.
It wraps the ETS model presented in the forecast library.
}
\examples{
library(daltoolbox)

#loading the example database
data(examples_changepoints)

#Using simple example
dataset <- examples_changepoints$simple
head(dataset)

# setting up change point method
model <- hcp_cf_ets()

# fitting the model
model <- fit(model, dataset$serie)

detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
