% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmu_pca.R
\name{hmu_pca}
\alias{hmu_pca}
\title{Multivariate anomaly detector using PCA}
\usage{
hmu_pca()
}
\value{
\code{hmu_pca} object
}
\description{
Multivariate anomaly detector using PCA \url{doi:10.1016/0098-3004(93)90090-R}
}
\examples{
library(daltoolbox)

#loading the example database
data(har_examples_multi)

#Using the time series 9
dataset <- har_examples_multi$example1
head(dataset)

# establishing hmu_pca method
model <- hmu_pca()

# fitting the model using the two columns of the dataset
model <- fit(model, dataset[,1:2])

# making detections using hmu_pca
detection <- detect(model, dataset[,1:2])

# filtering detected events
print(detection[(detection$event),])

# evaluating the detections
evaluation <- evaluate(model, detection$event, dataset$event)
print(evaluation$confMatrix)
}
