% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wms_info.R
\name{get_wms_info}
\alias{get_wms_info}
\title{Retrieve additional information for wms layer}
\usage{
get_wms_info(
  shape,
  apikey = "ortho",
  layer_name = "ORTHOIMAGERY.ORTHOPHOTOS",
  version = "1.3.0"
)
}
\arguments{
\item{shape}{Object of class \code{sf} or \code{sfc}. Needs to be located in
France.}

\item{apikey}{API key from \code{get_apikeys()} or directly
from \href{https://geoservices.ign.fr/services-web-experts}{IGN website}}

\item{layer_name}{Name of the layer from \code{get_layers_metadata(apikey, "wms")}
or directly from
\href{https://geoservices.ign.fr/services-web-experts}{IGN website}}

\item{version}{The version of the service used. More details at
\href{https://geoservices.ign.fr/documentation/services/api-et-services-ogc/images-wms-ogc}{IGN documentation}}
}
\value{
character containing additional information from the layer
}
\description{
For some wms layer more information can be found with GetFeatureInfo request.
This function first check if info are available. If not, available layers
are returned.
}
\details{
#' @usage
get_wms_info(shape,
apikey = "ortho",
layer_name = "ORTHOIMAGERY.ORTHOPHOTOS.BDORTHO",
version = "1.3.0"
}
\examples{
\dontrun{
library(sf)

penmarch <- system.file("extdata/penmarch.shp", package = "happign")

wms_info <- get_wms_info(penmarch, "ortho", "ORTHOIMAGERY.ORTHOPHOTOS")

# orthophoto is from summer 2021
wms_info

}
}
