% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wms_raster.R
\name{get_wms_raster}
\alias{get_wms_raster}
\title{Download WMS raster layer}
\usage{
get_wms_raster(shape,
               apikey = "altimetrie",
               layer_name = "ELEVATION.ELEVATIONGRIDCOVERAGE",
               resolution = 25,
               filename = NULL,
               version = "1.3.0",
               format = "image/geotiff",
               styles = "",
               method = "auto",
               mode = "wb")
}
\arguments{
\item{shape}{Object of class \code{sf}. Needs to be located in
France.}

\item{apikey}{API key from \code{get_apikeys()} or directly
from \href{https://geoservices.ign.fr/services-web-experts}{IGN website}}

\item{layer_name}{Name of the layer from \code{get_layers_metadata(apikey, "wms")}
or directly from
\href{https://geoservices.ign.fr/services-web-experts}{IGN website}}

\item{resolution}{Cell size in meter. WMS are limited to 2048x2048 pixels so
depending of the shape and the resolution, correct number and size of tiles
is calculated. See detail for more information about resolution.}

\item{filename}{Either a character string naming a file or a connection open
for writing. (ex : "test" or "~/test"). The resolution is automatically
added to the filename. If raster with same name is already downloaded it
is directly imported into R. You don't have to specify the extension because
it is defined in the argument \code{format}.}

\item{version}{The version of the service used. See detail for more
information about \code{version}.}

\item{format}{The output format of the image file. Set
to geotiff by default. See detail for more information about \code{format}.}

\item{styles}{The rendering style of the layers. Set to "" by default.
See detail for more information about \code{styles}.}

\item{method}{Method to be used for downloading files. See \code{\link[=download.file]{download.file()}}
for more detail.}

\item{mode}{The mode with which to write the file. See \code{\link[=download.file]{download.file()}}
for more detail.}
}
\value{
\code{get_wms_raster} return an object of class \code{stars}. Depending on the layer,
this can be a simple raster (2 dimensions and 1 attribute) or an RGB
raster (3 dimensions and 1 attribute).
}
\description{
Directly download a raster layer from the French National Institute
of Geographic and Forestry. To do that, it need a location giving by
a shapefile, an apikey and the name of layer. You can find those
information from
\href{https://geoservices.ign.fr/services-web-experts}{IGN website}
}
\details{
\itemize{
\item Setting the \code{resolution} parameter higher than the base resolution
of the layer multiplies the number of pixels without increasing
the precision. For example, the download of the BD Alti layer from
IGN will be optimal for a resolution of 25m.
\item \code{version}, \code{format} and \code{styles} parameters are detailed on
\href{https://geoservices.ign.fr/documentation/services/api-et-services-ogc/images-wms-ogc}{IGN documentation}
}
}
\examples{
\dontrun{
library(sf)
library(stars)
library(tmap)

apikey <- get_apikeys()[4]

metadata_table <- get_layers_metadata(apikey, "wms")
layer_name <- as.character(metadata_table[2,2])

# shape from the best town in France
shape <- st_polygon(list(matrix(c(-4.373937, 47.79859,
                                 -4.375615, 47.79738,
                                 -4.375147, 47.79683,
                                 -4.373898, 47.79790,
                                 -4.373937, 47.79859),
                                 ncol = 2, byrow = TRUE)))
shape <- st_sfc(shape, crs = st_crs(4326))

# Downloading digital elevation model from IGN
mnt <- get_wms_raster(shape, apikey, layer_name, resolution = 25, filename = "raster_name")
file.remove("raster_name_25m.tif") # Don't want to keep raster on disk
mnt[mnt < 0] <- NA # remove negative values in case of singularity
names(mnt) <- "Elevation [m]" # Rename raster ie the title legend

# Verif
qtm(mnt)+
qtm(shape, fill = NULL, borders.lwd = 3)
}
}
\seealso{
\code{\link[=get_apikeys]{get_apikeys()}}, \code{\link[=get_layers_metadata]{get_layers_metadata()}}, \code{\link[=download.file]{download.file()}}
}
