% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wms_info.R
\name{get_wms_info}
\alias{get_wms_info}
\title{Retrieve additional information for wms layer}
\usage{
get_wms_info(
  shape,
  apikey = "ortho",
  layer_name = "ORTHOIMAGERY.ORTHOPHOTOS",
  version = "1.3.0"
)
}
\arguments{
\item{shape}{Object of class \code{sf}. Needs to be located in
France.}

\item{apikey}{API key from \code{get_apikeys()} or directly
from \href{https://geoservices.ign.fr/services-web-experts}{IGN website}}

\item{layer_name}{Name of the layer from \code{get_layers_metadata(apikey, "wms")}
or directly from
\href{https://geoservices.ign.fr/services-web-experts}{IGN website}}

\item{version}{The version of the service used. More details at
\href{https://geoservices.ign.fr/documentation/services/api-et-services-ogc/images-wms-ogc}{IGN documentation}}
}
\value{
data.frame containing additional information from the layer
}
\description{
#' @usage
get_wms_info(shape,
apikey = "ortho",
layer_name = "ORTHOIMAGERY.ORTHOPHOTOS.BDORTHO",
version = "1.3.0"
}
\examples{
\dontrun{
library(sf)

shape <- st_polygon(list(matrix(c(-4.373937, 47.79859,
                                 -4.375615, 47.79738,
                                 -4.375147, 47.79683,
                                 -4.373898, 47.79790,
                                 -4.373937, 47.79859),
                                 ncol = 2, byrow = TRUE)))
shape <- st_sfc(shape, crs = st_crs(4326))

wms_info <- get_wms_info(shape, "ortho", "ORTHOIMAGERY.ORTHOPHOTOS")

date_vol <- wms_info$date_vol

}
}
