% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff_writer.R
\name{cff_writer}
\alias{cff_writer}
\title{Citation File Format (cff) writer}
\usage{
cff_writer(z, path = NULL)
}
\arguments{
\item{z}{an object of class \code{handl}; see \link{handl} for more}

\item{path}{a file path or connection; default: \code{stdout()}}
}
\value{
text if one cff citation or list of many
}
\description{
Citation File Format (cff) writer
}
\details{
uses \code{yaml::write_yaml} to write to yaml format that
CFF uses
}
\section{Converting to CFF from other formats}{

CFF has required fields that can't be missing. This means that
converting from other citation types to CFF will likely require
adding the required CFF fields manually. Adding fields to a
\code{handl} object is easy: it's really just an R list so add
named elements to it. The required CFF fields are:
\itemize{
\item cff-version: add \code{cff_version}
\item message: add \code{message}
\item version: add \code{software_version}
\item title: add \code{title}
\item authors: add \code{author}
\item date-released: add \code{date_published}
}
}

\examples{
(z <- system.file('extdata/citation.cff', package = "handlr"))
res <- cff_reader(x = z)
res
unclass(res)
cff_writer(res)
cat(cff_writer(res))
f <- tempfile()
cff_writer(res, f)
readLines(f)
unlink(f)

# convert from a different citation format
## see "Converting to CFF from other formats" above
z <- system.file('extdata/citeproc.json', package = "handlr")
w <- citeproc_reader(x = z)
# cff_writer(w) # fails unless we add required fields
w$cff_version <- "1.1.0"
w$message <- "Please cite the following works when using this software."
w$software_version <- "2.5"
w$title <- "A cool library"
w$date_published <- "2017-12-18"
cff_writer(w)
cat(cff_writer(w))
}
\references{
CFF format:
https://github.com/citation-file-format/citation-file-format
}
\seealso{
Other writers: 
\code{\link{bibtex_writer}()},
\code{\link{citeproc_writer}()},
\code{\link{codemeta_writer}()},
\code{\link{rdf_xml_writer}()},
\code{\link{ris_writer}()},
\code{\link{schema_org_writer}()}

Other cff: 
\code{\link{cff_reader}()}
}
\concept{cff}
\concept{writers}
