% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sl_hal9001.R
\name{SL.hal9001}
\alias{SL.hal9001}
\title{Wrapper for Classic SuperLearner}
\usage{
SL.hal9001(
  Y,
  X,
  newX = NULL,
  max_degree = 3,
  fit_type = c("glmnet", "lassi"),
  n_folds = 10,
  use_min = TRUE,
  family = stats::gaussian(),
  obsWeights = rep(1, length(Y)),
  ...
)
}
\arguments{
\item{Y}{A \code{numeric} of outcomes.}

\item{X}{A \code{matrix} of predictors/covariates.}

\item{newX}{A matrix of new observations on which to obtain predictions. The
default of \code{NULL} computes predictions on training inputs \code{X}.}

\item{max_degree}{The highest order of interaction terms for which the basis
functions ought to be generated. \code{NULL} corresponds to generating
basis functions for the full dimensionality of the input matrix.}

\item{fit_type}{The specific routine to be called when fitting the Lasso
regression via cross-validation. Choosing \code{cv.glmnet} option results
in option results in a call to \code{\link[glmnet]{cv.glmnet}} while
\code{lassi} produces a (faster) call to a custom routine based on a custom
routine for fitting the Lasso.}

\item{n_folds}{Integer for the number of folds to be used when splitting the
data for cross-validation. This defaults to 10 as this is the convention
for V-fold cross-validation.}

\item{use_min}{Determines which lambda is selected from \code{cv.glmnet}.
\code{TRUE} corresponds to \code{"lambda.min"} and \code{FALSE} corresponds
to \code{"lambda.1se"}.}

\item{family}{Not used by the function directly, but meant to ensure
compatibility with \code{SuperLearner}.}

\item{obsWeights}{Not used by the function directly, but meant to ensure
compatibility with \code{SuperLearner}. These are passed to
\code{\link[glmnet]{cv.glmnet}} through the \code{...} argument of
\code{\link{fit_hal}}.}

\item{...}{Placeholder (ignored).}
}
\value{
An object of class \code{SL.hal9001} with a fitted \code{hal9001}
 object and corresponding predictions based on the input data.
}
\description{
Wrapper for \pkg{SuperLearner} for objects of class \code{hal9001}
}
