% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_dupes.R
\name{make_copy_map}
\alias{make_copy_map}
\title{Build Copy Maps}
\usage{
make_copy_map(x_basis)
}
\arguments{
\item{x_basis}{A design matrix consisting of basis (indicator) functions for
covariates (X) and terms for interactions thereof.}
}
\value{
A \code{list} of \code{numeric} vectors indicating indices of basis
 functions that are identical in the training set.
}
\description{
Build Copy Maps
}
\examples{
\donttest{
gendata <- function(n) {
  W1 <- runif(n, -3, 3)
  W2 <- rnorm(n)
  W3 <- runif(n)
  W4 <- rnorm(n)
  g0 <- plogis(0.5 * (-0.8 * W1 + 0.39 * W2 + 0.08 * W3 - 0.12 * W4))
  A <- rbinom(n, 1, g0)
  Q0 <- plogis(0.15 * (2 * A + 2 * A * W1 + 6 * A * W3 * W4 - 3))
  Y <- rbinom(n, 1, Q0)
  data.frame(A, W1, W2, W3, W4, Y)
}
set.seed(1234)
data <- gendata(100)
covars <- setdiff(names(data), "Y")
X <- as.matrix(data[, covars, drop = FALSE])
basis_list <- enumerate_basis(X)
x_basis <- make_design_matrix(X, basis_list)
copy_map <- make_copy_map(x_basis)
}

}
