% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_cf.R
\name{store_correl}
\alias{store_correl}
\title{Store a 'raw_cf' correlator in an associative array together with a description
The object \code{cf} will be stored as an element of \code{cmap} under key \code{out_key}
in the member \code{obj} of \code{cmap}. The data frame passed via \code{desc} will be
appended as a row to \code{cmap[[out_key]]$map}. If \code{out_key} does not exist
as a key in \code{cmap}, a new element will be created. If it already exists,
\code{addStat.raw_cf} is called to add statistics to the existing \code{raw_cf}. Requires
the 'hash' package.}
\usage{
store_correl(cmap, cf, out_key, desc)
}
\arguments{
\item{cmap}{Object of class \code{hash} to act as storage for 'raw_cf' correlators.}

\item{cf}{Object of class \code{raw_cf} to be stored in \code{cmap}.}

\item{out_key}{String, key associated with \code{cf} object to be stored in \code{cmap}.}

\item{desc}{Single row data frame containing some descriptive parameters for \code{cf}.}
}
\value{
Since objects of class \code{hash} are passed and modified by reference, there
is no explicit return value. Instead, the passed \code{cmap} is modified.
}
\description{
Store a 'raw_cf' correlator in an associative array together with a description
The object \code{cf} will be stored as an element of \code{cmap} under key \code{out_key}
in the member \code{obj} of \code{cmap}. The data frame passed via \code{desc} will be
appended as a row to \code{cmap[[out_key]]$map}. If \code{out_key} does not exist
as a key in \code{cmap}, a new element will be created. If it already exists,
\code{addStat.raw_cf} is called to add statistics to the existing \code{raw_cf}. Requires
the 'hash' package.
}
