% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hankel.R
\name{gevp.hankel_summed}
\alias{gevp.hankel_summed}
\title{GEVP method based on Hankel matrices.}
\usage{
gevp.hankel_summed(cf, t0values = c(1), deltat = 1, n, N)
}
\arguments{
\item{cf}{Numeric vector (this will generally be the time slices of a correlation function).}

\item{t0values}{Integer vector. The t0 values to sum over.}

\item{deltat}{Integer. The value of the time shift to use to build the Hankel matrices.}

\item{n}{Integer. Size of the Hankel matrices to generate}

\item{N}{Integer. Maximal time index in correlation function to be used in
Hankel matrix}
}
\value{
A complex vector of length \code{n + n^2} which contains the eigenvalues in the first
\code{n} elements and the eigenvectors in the remaining \code{n^2} elements.

A vector of NAs of \code{n + n^2} is returend in case the QR decomposition fails.
}
\description{
Alternative method to determine energy levels from correlation
matrices. A so-called Hankel matrix is generated from an input
real numeric vector and a generalised eigenvalue problem is solved
then.
}
\seealso{
Other hankel: 
\code{\link{bootstrap.hankel_summed}()},
\code{\link{bootstrap.hankel}()},
\code{\link{gevp.hankel}()},
\code{\link{hankel2cf}()},
\code{\link{hankel2effectivemass}()},
\code{\link{plot_hankel_spectrum}()}
}
\concept{hankel}
