/*
    hBayesDM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hBayesDM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hBayesDM.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_wcs_sql_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_wcs_sql");
    reader.add_event(0, 0, "include", "/pre/license.stan");
    reader.add_event(0, 0, "start", "/pre/license.stan");
    reader.add_event(14, 14, "end", "/pre/license.stan");
    reader.add_event(14, 1, "restart", "model_wcs_sql");
    reader.add_event(190, 175, "end", "model_wcs_sql");
    return reader;
}

#include <meta_header.hpp>
 class model_wcs_sql : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<vector<int> > > choice;
    vector<vector<int> > outcome;
    vector<vector<matrix_d> > choice_match_att;
    vector<matrix_d> deck_match_rule;
    matrix_d initAtt;
    matrix_d unit;
public:
    model_wcs_sql(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_wcs_sql(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_wcs_sql_namespace::model_wcs_sql";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 19;
            validate_non_negative_index("Tsubj", "N", N);
            context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
            validate_non_negative_index("Tsubj", "N", N);
            Tsubj = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("Tsubj");
            pos__ = 0;
            size_t Tsubj_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
                Tsubj[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 21;
            validate_non_negative_index("choice", "N", N);
            validate_non_negative_index("choice", "4", 4);
            validate_non_negative_index("choice", "T", T);
            context__.validate_dims("data initialization", "choice", "int", context__.to_vec(N,4,T));
            validate_non_negative_index("choice", "N", N);
            validate_non_negative_index("choice", "4", 4);
            validate_non_negative_index("choice", "T", T);
            choice = std::vector<std::vector<std::vector<int> > >(N,std::vector<std::vector<int> >(4,std::vector<int>(T,int(0))));
            vals_i__ = context__.vals_i("choice");
            pos__ = 0;
            size_t choice_limit_2__ = T;
            for (size_t i_2__ = 0; i_2__ < choice_limit_2__; ++i_2__) {
                size_t choice_limit_1__ = 4;
                for (size_t i_1__ = 0; i_1__ < choice_limit_1__; ++i_1__) {
                    size_t choice_limit_0__ = N;
                    for (size_t i_0__ = 0; i_0__ < choice_limit_0__; ++i_0__) {
                        choice[i_0__][i_1__][i_2__] = vals_i__[pos__++];
                    }
                }
            }
            current_statement_begin__ = 22;
            validate_non_negative_index("outcome", "N", N);
            validate_non_negative_index("outcome", "T", T);
            context__.validate_dims("data initialization", "outcome", "int", context__.to_vec(N,T));
            validate_non_negative_index("outcome", "N", N);
            validate_non_negative_index("outcome", "T", T);
            outcome = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("outcome");
            pos__ = 0;
            size_t outcome_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < outcome_limit_1__; ++i_1__) {
                size_t outcome_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < outcome_limit_0__; ++i_0__) {
                    outcome[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 23;
            validate_non_negative_index("choice_match_att", "N", N);
            validate_non_negative_index("choice_match_att", "T", T);
            validate_non_negative_index("choice_match_att", "1", 1);
            validate_non_negative_index("choice_match_att", "3", 3);
            context__.validate_dims("data initialization", "choice_match_att", "matrix_d", context__.to_vec(N,T,1,3));
            validate_non_negative_index("choice_match_att", "N", N);
            validate_non_negative_index("choice_match_att", "T", T);
            validate_non_negative_index("choice_match_att", "1", 1);
            validate_non_negative_index("choice_match_att", "3", 3);
            choice_match_att = std::vector<std::vector<matrix_d> >(N,std::vector<matrix_d>(T,matrix_d(static_cast<Eigen::VectorXd::Index>(1),static_cast<Eigen::VectorXd::Index>(3))));
            vals_r__ = context__.vals_r("choice_match_att");
            pos__ = 0;
            size_t choice_match_att_m_mat_lim__ = 1;
            size_t choice_match_att_n_mat_lim__ = 3;
            for (size_t n_mat__ = 0; n_mat__ < choice_match_att_n_mat_lim__; ++n_mat__) {
                for (size_t m_mat__ = 0; m_mat__ < choice_match_att_m_mat_lim__; ++m_mat__) {
                    size_t choice_match_att_limit_1__ = T;
                    for (size_t i_1__ = 0; i_1__ < choice_match_att_limit_1__; ++i_1__) {
                        size_t choice_match_att_limit_0__ = N;
                        for (size_t i_0__ = 0; i_0__ < choice_match_att_limit_0__; ++i_0__) {
                            choice_match_att[i_0__][i_1__](m_mat__,n_mat__) = vals_r__[pos__++];
                }
            }
                }
            }
            current_statement_begin__ = 24;
            validate_non_negative_index("deck_match_rule", "T", T);
            validate_non_negative_index("deck_match_rule", "3", 3);
            validate_non_negative_index("deck_match_rule", "4", 4);
            context__.validate_dims("data initialization", "deck_match_rule", "matrix_d", context__.to_vec(T,3,4));
            validate_non_negative_index("deck_match_rule", "T", T);
            validate_non_negative_index("deck_match_rule", "3", 3);
            validate_non_negative_index("deck_match_rule", "4", 4);
            deck_match_rule = std::vector<matrix_d>(T,matrix_d(static_cast<Eigen::VectorXd::Index>(3),static_cast<Eigen::VectorXd::Index>(4)));
            vals_r__ = context__.vals_r("deck_match_rule");
            pos__ = 0;
            size_t deck_match_rule_m_mat_lim__ = 3;
            size_t deck_match_rule_n_mat_lim__ = 4;
            for (size_t n_mat__ = 0; n_mat__ < deck_match_rule_n_mat_lim__; ++n_mat__) {
                for (size_t m_mat__ = 0; m_mat__ < deck_match_rule_m_mat_lim__; ++m_mat__) {
                    size_t deck_match_rule_limit_0__ = T;
                    for (size_t i_0__ = 0; i_0__ < deck_match_rule_limit_0__; ++i_0__) {
                        deck_match_rule[i_0__](m_mat__,n_mat__) = vals_r__[pos__++];
            }
                }
            }

            // validate, data variables
            current_statement_begin__ = 17;
            check_greater_or_equal(function__,"N",N,1);
            current_statement_begin__ = 18;
            check_greater_or_equal(function__,"T",T,1);
            current_statement_begin__ = 19;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],40);
                check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
            }
            current_statement_begin__ = 21;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < 4; ++k1__) {
                    for (int k2__ = 0; k2__ < T; ++k2__) {
                        check_greater_or_equal(function__,"choice[k0__][k1__][k2__]",choice[k0__][k1__][k2__],0);
                        check_less_or_equal(function__,"choice[k0__][k1__][k2__]",choice[k0__][k1__][k2__],4);
                    }
                }
            }
            current_statement_begin__ = 22;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"outcome[k0__][k1__]",outcome[k0__][k1__],-(1));
                    check_less_or_equal(function__,"outcome[k0__][k1__]",outcome[k0__][k1__],1);
                }
            }
            current_statement_begin__ = 23;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"choice_match_att[k0__][k1__]",choice_match_att[k0__][k1__],0);
                    check_less_or_equal(function__,"choice_match_att[k0__][k1__]",choice_match_att[k0__][k1__],1);
                }
            }
            current_statement_begin__ = 24;
            for (int k0__ = 0; k0__ < T; ++k0__) {
                check_greater_or_equal(function__,"deck_match_rule[k0__]",deck_match_rule[k0__],0);
                check_less_or_equal(function__,"deck_match_rule[k0__]",deck_match_rule[k0__],1);
            }
            // initialize data variables
            current_statement_begin__ = 28;
            validate_non_negative_index("initAtt", "1", 1);
            validate_non_negative_index("initAtt", "3", 3);
            initAtt = matrix_d(static_cast<Eigen::VectorXd::Index>(1),static_cast<Eigen::VectorXd::Index>(3));
            stan::math::fill(initAtt,DUMMY_VAR__);
            current_statement_begin__ = 29;
            validate_non_negative_index("unit", "1", 1);
            validate_non_negative_index("unit", "3", 3);
            unit = matrix_d(static_cast<Eigen::VectorXd::Index>(1),static_cast<Eigen::VectorXd::Index>(3));
            stan::math::fill(unit,DUMMY_VAR__);

            current_statement_begin__ = 31;
            stan::math::assign(initAtt, rep_matrix((1.0 / 3.0),1,3));
            current_statement_begin__ = 32;
            stan::math::assign(unit, rep_matrix(1.0,1,3));

            // validate transformed data
            current_statement_begin__ = 28;
            current_statement_begin__ = 29;

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 37;
            validate_non_negative_index("mu_pr", "3", 3);
            num_params_r__ += 3;
            current_statement_begin__ = 38;
            validate_non_negative_index("sigma", "3", 3);
            num_params_r__ += 3;
            current_statement_begin__ = 41;
            validate_non_negative_index("r_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 42;
            validate_non_negative_index("p_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 43;
            validate_non_negative_index("d_pr", "N", N);
            num_params_r__ += N;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_wcs_sql() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_pr")))
            throw std::runtime_error("variable mu_pr missing");
        vals_r__ = context__.vals_r("mu_pr");
        pos__ = 0U;
        validate_non_negative_index("mu_pr", "3", 3);
        context__.validate_dims("initialization", "mu_pr", "vector_d", context__.to_vec(3));
        vector_d mu_pr(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            mu_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_pr: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "3", 3);
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(3));
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("r_pr")))
            throw std::runtime_error("variable r_pr missing");
        vals_r__ = context__.vals_r("r_pr");
        pos__ = 0U;
        validate_non_negative_index("r_pr", "N", N);
        context__.validate_dims("initialization", "r_pr", "vector_d", context__.to_vec(N));
        vector_d r_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            r_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(r_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable r_pr: ") + e.what());
        }

        if (!(context__.contains_r("p_pr")))
            throw std::runtime_error("variable p_pr missing");
        vals_r__ = context__.vals_r("p_pr");
        pos__ = 0U;
        validate_non_negative_index("p_pr", "N", N);
        context__.validate_dims("initialization", "p_pr", "vector_d", context__.to_vec(N));
        vector_d p_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            p_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(p_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable p_pr: ") + e.what());
        }

        if (!(context__.contains_r("d_pr")))
            throw std::runtime_error("variable d_pr missing");
        vals_r__ = context__.vals_r("d_pr");
        pos__ = 0U;
        validate_non_negative_index("d_pr", "N", N);
        context__.validate_dims("initialization", "d_pr", "vector_d", context__.to_vec(N));
        vector_d d_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            d_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(d_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable d_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  mu_pr;
            (void) mu_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_pr = in__.vector_constrain(3,lp__);
            else
                mu_pr = in__.vector_constrain(3);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.vector_lb_constrain(0,3,lp__);
            else
                sigma = in__.vector_lb_constrain(0,3);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  r_pr;
            (void) r_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                r_pr = in__.vector_constrain(N,lp__);
            else
                r_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  p_pr;
            (void) p_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                p_pr = in__.vector_constrain(N,lp__);
            else
                p_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  d_pr;
            (void) d_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                d_pr = in__.vector_constrain(N,lp__);
            else
                d_pr = in__.vector_constrain(N);


            // transformed parameters
            current_statement_begin__ = 48;
            validate_non_negative_index("r", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  r(static_cast<Eigen::VectorXd::Index>(N));
            (void) r;  // dummy to suppress unused var warning

            stan::math::initialize(r, DUMMY_VAR__);
            stan::math::fill(r,DUMMY_VAR__);
            current_statement_begin__ = 49;
            validate_non_negative_index("p", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  p(static_cast<Eigen::VectorXd::Index>(N));
            (void) p;  // dummy to suppress unused var warning

            stan::math::initialize(p, DUMMY_VAR__);
            stan::math::fill(p,DUMMY_VAR__);
            current_statement_begin__ = 50;
            validate_non_negative_index("d", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  d(static_cast<Eigen::VectorXd::Index>(N));
            (void) d;  // dummy to suppress unused var warning

            stan::math::initialize(d, DUMMY_VAR__);
            stan::math::fill(d,DUMMY_VAR__);


            current_statement_begin__ = 52;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 53;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,1,"mu_pr",1) + (get_base1(sigma,1,"sigma",1) * get_base1(r_pr,i,"r_pr",1)))), 
                            "assigning variable r");
                current_statement_begin__ = 54;
                stan::model::assign(p, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,2,"mu_pr",1) + (get_base1(sigma,2,"sigma",1) * get_base1(p_pr,i,"p_pr",1)))), 
                            "assigning variable p");
                current_statement_begin__ = 55;
                stan::model::assign(d, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,3,"mu_pr",1) + (get_base1(sigma,3,"sigma",1) * get_base1(d_pr,i,"d_pr",1)))) * 5), 
                            "assigning variable d");
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(r(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: r" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(p(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: p" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(d(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: d" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 48;
            check_greater_or_equal(function__,"r",r,0);
            check_less_or_equal(function__,"r",r,1);
            current_statement_begin__ = 49;
            check_greater_or_equal(function__,"p",p,0);
            check_less_or_equal(function__,"p",p,1);
            current_statement_begin__ = 50;
            check_greater_or_equal(function__,"d",d,0);
            check_less_or_equal(function__,"d",d,5);

            // model body

            current_statement_begin__ = 61;
            lp_accum__.add(normal_log<propto__>(mu_pr, 0, 1));
            current_statement_begin__ = 62;
            lp_accum__.add(normal_log<propto__>(sigma, 0, 0.20000000000000001));
            current_statement_begin__ = 65;
            lp_accum__.add(normal_log<propto__>(r_pr, 0, 1));
            current_statement_begin__ = 66;
            lp_accum__.add(normal_log<propto__>(p_pr, 0, 1));
            current_statement_begin__ = 67;
            lp_accum__.add(normal_log<propto__>(d_pr, 0, 1));
            current_statement_begin__ = 69;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 71;
                validate_non_negative_index("pred_prob_mat", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  pred_prob_mat(static_cast<Eigen::VectorXd::Index>(4));
                (void) pred_prob_mat;  // dummy to suppress unused var warning

                stan::math::initialize(pred_prob_mat, DUMMY_VAR__);
                stan::math::fill(pred_prob_mat,DUMMY_VAR__);
                current_statement_begin__ = 72;
                validate_non_negative_index("subj_att", "1", 1);
                validate_non_negative_index("subj_att", "3", 3);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,Eigen::Dynamic>  subj_att(static_cast<Eigen::VectorXd::Index>(1),static_cast<Eigen::VectorXd::Index>(3));
                (void) subj_att;  // dummy to suppress unused var warning

                stan::math::initialize(subj_att, DUMMY_VAR__);
                stan::math::fill(subj_att,DUMMY_VAR__);
                current_statement_begin__ = 73;
                validate_non_negative_index("att_signal", "1", 1);
                validate_non_negative_index("att_signal", "3", 3);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,Eigen::Dynamic>  att_signal(static_cast<Eigen::VectorXd::Index>(1),static_cast<Eigen::VectorXd::Index>(3));
                (void) att_signal;  // dummy to suppress unused var warning

                stan::math::initialize(att_signal, DUMMY_VAR__);
                stan::math::fill(att_signal,DUMMY_VAR__);
                current_statement_begin__ = 74;
                local_scalar_t__ sum_att_signal;
                (void) sum_att_signal;  // dummy to suppress unused var warning

                stan::math::initialize(sum_att_signal, DUMMY_VAR__);
                stan::math::fill(sum_att_signal,DUMMY_VAR__);
                current_statement_begin__ = 75;
                validate_non_negative_index("tmpatt", "1", 1);
                validate_non_negative_index("tmpatt", "3", 3);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,Eigen::Dynamic>  tmpatt(static_cast<Eigen::VectorXd::Index>(1),static_cast<Eigen::VectorXd::Index>(3));
                (void) tmpatt;  // dummy to suppress unused var warning

                stan::math::initialize(tmpatt, DUMMY_VAR__);
                stan::math::fill(tmpatt,DUMMY_VAR__);
                current_statement_begin__ = 76;
                validate_non_negative_index("tmpp", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  tmpp(static_cast<Eigen::VectorXd::Index>(4));
                (void) tmpp;  // dummy to suppress unused var warning

                stan::math::initialize(tmpp, DUMMY_VAR__);
                stan::math::fill(tmpp,DUMMY_VAR__);


                current_statement_begin__ = 79;
                stan::math::assign(subj_att, initAtt);
                current_statement_begin__ = 80;
                stan::math::assign(pred_prob_mat, to_vector(multiply(subj_att,stan::model::rvalue(deck_match_rule, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "deck_match_rule"))));
                current_statement_begin__ = 82;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                    current_statement_begin__ = 84;
                    lp_accum__.add(multinomial_log<propto__>(stan::model::rvalue(choice, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()))), "choice"), pred_prob_mat));
                    current_statement_begin__ = 87;
                    if (as_bool(logical_eq(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2),1))) {

                        current_statement_begin__ = 88;
                        stan::math::assign(att_signal, elt_multiply(subj_att,get_base1(get_base1(choice_match_att,i,"choice_match_att",1),t,"choice_match_att",2)));
                        current_statement_begin__ = 89;
                        stan::math::assign(sum_att_signal, sum(att_signal));
                        current_statement_begin__ = 90;
                        stan::math::assign(att_signal, divide(att_signal, sum_att_signal));
                        current_statement_begin__ = 91;
                        stan::math::assign(tmpatt, add(multiply((1.0 - get_base1(r,i,"r",1)),subj_att),multiply(get_base1(r,i,"r",1),att_signal)));
                    } else {

                        current_statement_begin__ = 93;
                        stan::math::assign(att_signal, elt_multiply(subj_att,subtract(unit,get_base1(get_base1(choice_match_att,i,"choice_match_att",1),t,"choice_match_att",2))));
                        current_statement_begin__ = 94;
                        stan::math::assign(sum_att_signal, sum(att_signal));
                        current_statement_begin__ = 95;
                        stan::math::assign(att_signal, divide(att_signal, sum_att_signal));
                        current_statement_begin__ = 96;
                        stan::math::assign(tmpatt, add(multiply((1.0 - get_base1(p,i,"p",1)),subj_att),multiply(get_base1(p,i,"p",1),att_signal)));
                    }
                    current_statement_begin__ = 100;
                    stan::math::assign(subj_att, add(multiply(divide(tmpatt,sum(tmpatt)),0.99980000000000002),0.0001));
                    current_statement_begin__ = 102;
                    stan::model::assign(tmpatt, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                pow(get_base1(subj_att,1,1,"subj_att",1),get_base1(d,i,"d",1)), 
                                "assigning variable tmpatt");
                    current_statement_begin__ = 103;
                    stan::model::assign(tmpatt, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                                pow(get_base1(subj_att,1,2,"subj_att",1),get_base1(d,i,"d",1)), 
                                "assigning variable tmpatt");
                    current_statement_begin__ = 104;
                    stan::model::assign(tmpatt, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                                pow(get_base1(subj_att,1,3,"subj_att",1),get_base1(d,i,"d",1)), 
                                "assigning variable tmpatt");
                    current_statement_begin__ = 107;
                    if (as_bool(logical_lt(t,get_base1(Tsubj,i,"Tsubj",1)))) {

                        current_statement_begin__ = 108;
                        stan::math::assign(tmpp, add(multiply(to_vector(multiply(tmpatt,stan::model::rvalue(deck_match_rule, stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "deck_match_rule"))),0.99980000000000002),0.0001));
                        current_statement_begin__ = 109;
                        stan::math::assign(pred_prob_mat, divide(tmpp,sum(tmpp)));
                    }
                }
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_pr");
        names__.push_back("sigma");
        names__.push_back("r_pr");
        names__.push_back("p_pr");
        names__.push_back("d_pr");
        names__.push_back("r");
        names__.push_back("p");
        names__.push_back("d");
        names__.push_back("mu_r");
        names__.push_back("mu_p");
        names__.push_back("mu_d");
        names__.push_back("log_lik");
        names__.push_back("y_pred");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(4);
        dims__.push_back(T);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_wcs_sql_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d mu_pr = in__.vector_constrain(3);
        vector_d sigma = in__.vector_lb_constrain(0,3);
        vector_d r_pr = in__.vector_constrain(N);
        vector_d p_pr = in__.vector_constrain(N);
        vector_d d_pr = in__.vector_constrain(N);
            for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(mu_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(r_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(p_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(d_pr[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 48;
            validate_non_negative_index("r", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  r(static_cast<Eigen::VectorXd::Index>(N));
            (void) r;  // dummy to suppress unused var warning

            stan::math::initialize(r, DUMMY_VAR__);
            stan::math::fill(r,DUMMY_VAR__);
            current_statement_begin__ = 49;
            validate_non_negative_index("p", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  p(static_cast<Eigen::VectorXd::Index>(N));
            (void) p;  // dummy to suppress unused var warning

            stan::math::initialize(p, DUMMY_VAR__);
            stan::math::fill(p,DUMMY_VAR__);
            current_statement_begin__ = 50;
            validate_non_negative_index("d", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  d(static_cast<Eigen::VectorXd::Index>(N));
            (void) d;  // dummy to suppress unused var warning

            stan::math::initialize(d, DUMMY_VAR__);
            stan::math::fill(d,DUMMY_VAR__);


            current_statement_begin__ = 52;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 53;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,1,"mu_pr",1) + (get_base1(sigma,1,"sigma",1) * get_base1(r_pr,i,"r_pr",1)))), 
                            "assigning variable r");
                current_statement_begin__ = 54;
                stan::model::assign(p, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,2,"mu_pr",1) + (get_base1(sigma,2,"sigma",1) * get_base1(p_pr,i,"p_pr",1)))), 
                            "assigning variable p");
                current_statement_begin__ = 55;
                stan::model::assign(d, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,3,"mu_pr",1) + (get_base1(sigma,3,"sigma",1) * get_base1(d_pr,i,"d_pr",1)))) * 5), 
                            "assigning variable d");
            }

            // validate transformed parameters
            current_statement_begin__ = 48;
            check_greater_or_equal(function__,"r",r,0);
            check_less_or_equal(function__,"r",r,1);
            current_statement_begin__ = 49;
            check_greater_or_equal(function__,"p",p,0);
            check_less_or_equal(function__,"p",p,1);
            current_statement_begin__ = 50;
            check_greater_or_equal(function__,"d",d,0);
            check_less_or_equal(function__,"d",d,5);

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(r[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(p[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(d[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 117;
            local_scalar_t__ mu_r;
            (void) mu_r;  // dummy to suppress unused var warning

            stan::math::initialize(mu_r, DUMMY_VAR__);
            stan::math::fill(mu_r,DUMMY_VAR__);
            current_statement_begin__ = 118;
            local_scalar_t__ mu_p;
            (void) mu_p;  // dummy to suppress unused var warning

            stan::math::initialize(mu_p, DUMMY_VAR__);
            stan::math::fill(mu_p,DUMMY_VAR__);
            current_statement_begin__ = 119;
            local_scalar_t__ mu_d;
            (void) mu_d;  // dummy to suppress unused var warning

            stan::math::initialize(mu_d, DUMMY_VAR__);
            stan::math::fill(mu_d,DUMMY_VAR__);
            current_statement_begin__ = 122;
            validate_non_negative_index("log_lik", "N", N);
            vector<local_scalar_t__> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik,DUMMY_VAR__);
            current_statement_begin__ = 125;
            validate_non_negative_index("y_pred", "N", N);
            validate_non_negative_index("y_pred", "4", 4);
            validate_non_negative_index("y_pred", "T", T);
            vector<vector<vector<int> > > y_pred(N, (vector<vector<int> >(4, (vector<int>(T, 0)))));
            stan::math::fill(y_pred, std::numeric_limits<int>::min());


            current_statement_begin__ = 128;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 129;
                for (int t = 1; t <= T; ++t) {

                    current_statement_begin__ = 130;
                    for (int deck = 1; deck <= 4; ++deck) {

                        current_statement_begin__ = 131;
                        stan::model::assign(y_pred, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(deck), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()))), 
                                    -(1), 
                                    "assigning variable y_pred");
                    }
                }
            }
            current_statement_begin__ = 136;
            stan::math::assign(mu_r, Phi_approx(get_base1(mu_pr,1,"mu_pr",1)));
            current_statement_begin__ = 137;
            stan::math::assign(mu_p, Phi_approx(get_base1(mu_pr,2,"mu_pr",1)));
            current_statement_begin__ = 138;
            stan::math::assign(mu_d, (Phi_approx(get_base1(mu_pr,3,"mu_pr",1)) * 5));

            current_statement_begin__ = 141;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 142;
                validate_non_negative_index("subj_att", "1", 1);
                validate_non_negative_index("subj_att", "3", 3);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,Eigen::Dynamic>  subj_att(static_cast<Eigen::VectorXd::Index>(1),static_cast<Eigen::VectorXd::Index>(3));
                (void) subj_att;  // dummy to suppress unused var warning

                stan::math::initialize(subj_att, DUMMY_VAR__);
                stan::math::fill(subj_att,DUMMY_VAR__);
                current_statement_begin__ = 143;
                validate_non_negative_index("att_signal", "1", 1);
                validate_non_negative_index("att_signal", "3", 3);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,Eigen::Dynamic>  att_signal(static_cast<Eigen::VectorXd::Index>(1),static_cast<Eigen::VectorXd::Index>(3));
                (void) att_signal;  // dummy to suppress unused var warning

                stan::math::initialize(att_signal, DUMMY_VAR__);
                stan::math::fill(att_signal,DUMMY_VAR__);
                current_statement_begin__ = 144;
                validate_non_negative_index("pred_prob_mat", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  pred_prob_mat(static_cast<Eigen::VectorXd::Index>(4));
                (void) pred_prob_mat;  // dummy to suppress unused var warning

                stan::math::initialize(pred_prob_mat, DUMMY_VAR__);
                stan::math::fill(pred_prob_mat,DUMMY_VAR__);
                current_statement_begin__ = 146;
                validate_non_negative_index("tmpatt", "1", 1);
                validate_non_negative_index("tmpatt", "3", 3);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,Eigen::Dynamic>  tmpatt(static_cast<Eigen::VectorXd::Index>(1),static_cast<Eigen::VectorXd::Index>(3));
                (void) tmpatt;  // dummy to suppress unused var warning

                stan::math::initialize(tmpatt, DUMMY_VAR__);
                stan::math::fill(tmpatt,DUMMY_VAR__);
                current_statement_begin__ = 147;
                validate_non_negative_index("tmpp", "4", 4);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  tmpp(static_cast<Eigen::VectorXd::Index>(4));
                (void) tmpp;  // dummy to suppress unused var warning

                stan::math::initialize(tmpp, DUMMY_VAR__);
                stan::math::fill(tmpp,DUMMY_VAR__);
                current_statement_begin__ = 149;
                local_scalar_t__ sum_att_signal;
                (void) sum_att_signal;  // dummy to suppress unused var warning

                stan::math::initialize(sum_att_signal, DUMMY_VAR__);
                stan::math::fill(sum_att_signal,DUMMY_VAR__);


                current_statement_begin__ = 151;
                stan::math::assign(subj_att, initAtt);
                current_statement_begin__ = 152;
                stan::math::assign(pred_prob_mat, to_vector(multiply(subj_att,stan::model::rvalue(deck_match_rule, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "deck_match_rule"))));
                current_statement_begin__ = 154;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable log_lik");
                current_statement_begin__ = 156;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                    current_statement_begin__ = 158;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(log_lik, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "log_lik") + multinomial_log(stan::model::rvalue(choice, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()))), "choice"),pred_prob_mat)), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 160;
                    stan::model::assign(y_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()))), 
                                multinomial_rng(pred_prob_mat,1, base_rng__), 
                                "assigning variable y_pred");
                    current_statement_begin__ = 162;
                    if (as_bool(logical_eq(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2),1))) {

                        current_statement_begin__ = 163;
                        stan::math::assign(att_signal, elt_multiply(subj_att,get_base1(get_base1(choice_match_att,i,"choice_match_att",1),t,"choice_match_att",2)));
                        current_statement_begin__ = 164;
                        stan::math::assign(sum_att_signal, sum(att_signal));
                        current_statement_begin__ = 165;
                        stan::math::assign(att_signal, divide(att_signal, sum_att_signal));
                        current_statement_begin__ = 166;
                        stan::math::assign(tmpatt, add(multiply((1.0 - get_base1(r,i,"r",1)),subj_att),multiply(get_base1(r,i,"r",1),att_signal)));
                    } else {

                        current_statement_begin__ = 168;
                        stan::math::assign(att_signal, elt_multiply(subj_att,subtract(unit,get_base1(get_base1(choice_match_att,i,"choice_match_att",1),t,"choice_match_att",2))));
                        current_statement_begin__ = 169;
                        stan::math::assign(sum_att_signal, sum(att_signal));
                        current_statement_begin__ = 170;
                        stan::math::assign(att_signal, divide(att_signal, sum_att_signal));
                        current_statement_begin__ = 171;
                        stan::math::assign(tmpatt, add(multiply((1.0 - get_base1(p,i,"p",1)),subj_att),multiply(get_base1(p,i,"p",1),att_signal)));
                    }
                    current_statement_begin__ = 174;
                    stan::math::assign(subj_att, add(multiply(divide(tmpatt,sum(tmpatt)),0.99980000000000002),0.0001));
                    current_statement_begin__ = 176;
                    stan::model::assign(tmpatt, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                pow(get_base1(subj_att,1,1,"subj_att",1),get_base1(d,i,"d",1)), 
                                "assigning variable tmpatt");
                    current_statement_begin__ = 177;
                    stan::model::assign(tmpatt, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                                pow(get_base1(subj_att,1,2,"subj_att",1),get_base1(d,i,"d",1)), 
                                "assigning variable tmpatt");
                    current_statement_begin__ = 178;
                    stan::model::assign(tmpatt, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                                pow(get_base1(subj_att,1,3,"subj_att",1),get_base1(d,i,"d",1)), 
                                "assigning variable tmpatt");
                    current_statement_begin__ = 180;
                    if (as_bool(logical_lt(t,get_base1(Tsubj,i,"Tsubj",1)))) {

                        current_statement_begin__ = 181;
                        stan::math::assign(tmpp, add(multiply(to_vector(multiply(tmpatt,stan::model::rvalue(deck_match_rule, stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "deck_match_rule"))),0.99980000000000002),0.0001));
                        current_statement_begin__ = 182;
                        stan::math::assign(pred_prob_mat, divide(tmpp,sum(tmpp)));
                    }
                }
                }
            }

            // validate generated quantities
            current_statement_begin__ = 117;
            check_greater_or_equal(function__,"mu_r",mu_r,0);
            check_less_or_equal(function__,"mu_r",mu_r,1);
            current_statement_begin__ = 118;
            check_greater_or_equal(function__,"mu_p",mu_p,0);
            check_less_or_equal(function__,"mu_p",mu_p,1);
            current_statement_begin__ = 119;
            check_greater_or_equal(function__,"mu_d",mu_d,0);
            check_less_or_equal(function__,"mu_d",mu_d,5);
            current_statement_begin__ = 122;
            current_statement_begin__ = 125;

            // write generated quantities
        vars__.push_back(mu_r);
        vars__.push_back(mu_p);
        vars__.push_back(mu_d);
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }
            for (int k_2__ = 0; k_2__ < T; ++k_2__) {
                for (int k_1__ = 0; k_1__ < 4; ++k_1__) {
                    for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                    vars__.push_back(y_pred[k_0__][k_1__][k_2__]);
                    }
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_wcs_sql";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "r_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "d_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "r" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "p" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "d" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_r";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_p";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_d";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_2__ = 1; k_2__ <= T; ++k_2__) {
            for (int k_1__ = 1; k_1__ <= 4; ++k_1__) {
                for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__ << '.' << k_2__;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "r_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "d_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "r" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "p" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "d" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_r";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_p";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_d";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_2__ = 1; k_2__ <= T; ++k_2__) {
            for (int k_1__ = 1; k_1__ <= 4; ++k_1__) {
                for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__ << '.' << k_2__;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
    }

}; // model

}

typedef model_wcs_sql_namespace::model_wcs_sql stan_model;


#endif
