% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{get_seed.H2OModel}
\alias{get_seed.H2OModel}
\alias{h2o.get_seed}
\title{Get the seed from H2OModel which was used during training.
If a user does not set the seed parameter before training, the seed is autogenerated.
It returns seed as the string if the value is bigger than the integer.
For example, an autogenerated seed is always long so that the seed in R is a string.}
\usage{
get_seed.H2OModel(object)

h2o.get_seed(object)
}
\arguments{
\item{object}{a fitted \linkS4class{H2OModel} object.}
}
\value{
Returns seed to be used during training a model. Could be numeric or string.
}
\description{
Get the seed from H2OModel which was used during training.
If a user does not set the seed parameter before training, the seed is autogenerated.
It returns seed as the string if the value is bigger than the integer.
For example, an autogenerated seed is always long so that the seed in R is a string.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(path = prostate_path)
prostate$CAPSULE <- as.factor(prostate$CAPSULE)
prostate_gbm <- h2o.gbm(3:9, "CAPSULE", prostate)
seed <- h2o.get_seed(prostate_gbm)
}
}
