% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{signif}
\alias{signif}
\title{Compute Z score and p-value for parameter of focus}
\usage{
signif(result, focus, signAdj = NULL)
}
\arguments{
\item{result}{output from \link{loadResults}}

\item{focus}{parameter name on which to calculate a Z score and p-value}

\item{signAdj}{name of column. Value of focus parameter is multiplied by the sign of the named column}
}
\value{
result with new Z and P columns
}
\description{
The \code{signAdj} column is important and not optional for latent
factor models.  Loadings to factor indicators can take any sign. If
your focus is the regression from the SNP to the factor then this
regression estimate will need to be multiplied by the sign of one
of the factor loadings. Pick a loading associated with a strong
indicator of the factor.
}
\details{
Two columns are added, \code{Z} and \code{P}. \code{Z} is the
focal parameter divded by its standard error. \code{P} is the
unadjusted two-sided normal CDF corresponding to the absolute
\code{Z} score.
}
\examples{
tdir <- tempdir()
dir <- system.file("extdata", package = "gwsem")
pheno <- data.frame(anxiety=rnorm(500))
m1 <- buildItem(pheno, 'anxiety')
GWAS(m1, file.path(dir,"example.pgen"),
    file.path(tdir,"out.log"))
r1 <- loadResults(file.path(tdir,"out.log"), "snp_to_anxiety")
r1 <- signif(r1, "snp_to_anxiety")
}
\seealso{
Other reporting: 
\code{\link{isSuspicious}()},
\code{\link{loadResults}()},
\code{\link{plot.gwsemResult}()},
\code{\link{signifGxE}()}
}
\concept{reporting}
