% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{loadResults}
\alias{loadResults}
\title{Load GWAS results into a single data.frame}
\usage{
loadResults(
  path,
  focus,
  ...,
  extraColumns = c(),
  .retainSE = deprecated(),
  signAdj = deprecated(),
  moderatorLevel = deprecated()
)
}
\arguments{
\item{path}{vector of paths to result files created by \link{GWAS}}

\item{focus}{parameter name on which to calculate a Z score and p-value}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{extraColumns}{character vector of additional columns to load}

\item{.retainSE}{logical. Keep a column for the SE of the focus parameter}

\item{signAdj}{name of column. Value of focus parameter is multiplied by the sign of the named column}

\item{moderatorLevel}{\lifecycle{deprecated}}
}
\value{
a data.table with one row per SNP
}
\description{
\lifecycle{maturing}
A1 is the reference allele and A2 is the alternate allele.
}
\examples{
tdir <- tempdir()
dir <- system.file("extdata", package = "gwsem")
pheno <- data.frame(anxiety=rnorm(500))
m1 <- buildItem(pheno, 'anxiety')
GWAS(m1, file.path(dir,"example.pgen"),
    file.path(tdir,"out.log"))
loadResults(file.path(tdir,"out.log"), "snp2anxiety")
}
\seealso{
Other reporting: 
\code{\link{isSuspicious}()},
\code{\link{plot.gwsemResult}()},
\code{\link{signifGxE}()},
\code{\link{signif}()}
}
\concept{reporting}
