% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwer.diag.plots.R
\name{gwer.diag.plots}
\alias{gwer.diag.plots}
\title{Diagnostic Plots for Geographically Weighted Elliptical Regression Models}
\usage{
gwer.diag.plots(object, gwerdiag = NULL, which, subset = NULL,
  iden = F, labels = NULL, ret = F, ...)
}
\arguments{
\item{object}{an object with the result of the fitted geographically weighted elliptical regression models.}

\item{gwerdiag}{objects containing the diagnostic measures. If is \code{NULL} (by default) is obtained from object.}

\item{which}{an optional numeric value with the number of plot returned.}

\item{subset}{an optional numeric vector specifying a subset of observations to be used in the fitting process.}

\item{iden}{a logical value used to identify observations. If \code{TRUE} the observations are identified in the graphic window.}

\item{labels}{a optinal string vector specifying a labels plots.}

\item{ret}{a logical value to return the diagnostic measures computing. If \code{FALSE} (by default) not return the diagnostic measures.}

\item{...}{graphics parameters to be passed to the plotting routines.}
}
\value{
Return an interactive menu with eleven options to make plots. This menu contains the follows graphics :
1: plot: All.
2: plot: Response residual against fitted values.
3: plot: Moran dispersion of the response residual.
4: plot: Standardized residual against fitted values.
5: plot: Moran dispersion of the standardized residual.
6: plot: QQ-plot of  response residuals.
7: plot: QQ-plot of  Standardized residuals.
8: plot: Generalized Leverage.
9: plot: Local influence on the response against index.
10: plot: Local influence on the scale against index.
11: plot: Local influence for case-weight against index.
If \code{which} is provided return an unique graphic selected. If \code{ret} is \code{TRUE} returns a list of diagnostic arrays 
(see \code{gwer.diag} for more details).
}
\description{
This function generate diagnostic measures plots for the fitted geographically weighted elliptical regression models.
}
\examples{
data(columbus, package="spData")
fit.lm <- lm(CRIME ~ INC, data=columbus)
summary(fit.lm)
gwer.bw <- gwer.sel(CRIME ~ INC, data=columbus, family = Normal(),
                 coords=cbind(columbus$X, columbus$Y))
gwer.fitn <- gwer(CRIME ~ INC, family = Normal(), bandwidth = gwer.bw, hatmatrix = TRUE,
                 spdisp = TRUE, parplot = FALSE, data=columbus, method = "gwer.fit",
                 coords=cbind(columbus$X, columbus$Y))
gwer.diag.plots(gwer.fitn, which=3)  
\donttest{
data(columbus, package="spData")
fit.elliptical <- elliptical(CRIME ~ INC, family = Student(df=4), data=columbus)
summary(fit.elliptical)
gwer.bw <- gwer.sel(CRIME ~ INC, data=columbus, family = Student(df=4),
                 coords=cbind(columbus$X, columbus$Y), method = 'aic')
gwer.fitt <- gwer(CRIME ~ INC, family = Student(df=4), bandwidth = gwer.bw, hatmatrix = TRUE,
                 spdisp = TRUE, parplot = TRUE, data=columbus, method = "gwer.fit",
                 coords=cbind(columbus$X, columbus$Y))
gwer.diag.plots(gwer.fitt, which=3)    
}
}
\references{
Galea, M., Paula, G. A., and Cysneiros, F. J. A. (2005). On diagnostics in 
symmetrical nonlinear models. Statistics & Probability Letters, 73(4), 459-467.
\url{https://doi.org/10.1016/j.spl.2005.04.033}
}
\seealso{
\code{\link{elliptical}}, \code{\link{elliptical.diag}}
}
\keyword{Diagnostic}
\keyword{Elliptical}
\keyword{Geographically}
\keyword{Regression}
\keyword{Weighted}
\keyword{methods}
\keyword{models}
