% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwer.diag.R
\name{gwer.diag}
\alias{gwer.diag}
\title{Diagnostic for Geographically Weighted Elliptical Regression Models}
\usage{
gwer.diag(object, ...)
}
\arguments{
\item{object}{an object with the result of the fitted geographically weighted elliptical regression model.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
Returns a list of diagnostic arrays:
\item{ro}{Ordinal residuals.}
\item{rr}{Response residuals.}
\item{rp}{Pearson residuals.}
\item{rs}{Studentized residuals.}
\item{rd}{Deviance residuals.}
\item{dispersion}{Coefficient of dispersion.}
\item{H}{The hat matrix.}
\item{h}{Main diagonal of the hat matrix.}
\item{GL}{Generalized leverage.}
\item{GLbeta}{Generalized leverage of location parameters estimation.}
\item{GLphi}{Generalized leverage of dispersion parameters estimation.}  
\item{DGbeta}{Cook distance of location parameters estimation.}
\item{DGphi}{Cook distance of dispersion parameters estimation.}  
\item{Cic}{Normal curvature for case-weight perturbation.}
\item{Cih}{Normal curvature for scale perturbation.}
\item{Lmaxr}{Local influence on response (additive perturbation in responce).}
\item{Lmaxc}{Local influence on coefficients (additive perturbation in predictors).}
}
\description{
This function obtains the values of differents residuals types and calculates the diagnostic measures for the fitted geographically weighted elliptical regression model.
}
\examples{
data(columbus, package="spData")
fit.lm <- lm(CRIME ~ INC, data=columbus)
summary(fit.lm)
gwer.bw <- gwer.sel(CRIME ~ INC, data=columbus, family = Normal(),
                 coords=cbind(columbus$X, columbus$Y))
gwer.fitn <- gwer(CRIME ~ INC, family = Normal(), bandwidth = gwer.bw, hatmatrix = TRUE, 
                 spdisp = TRUE, parplot = TRUE, data=columbus, method = "gwer.fit",
                 coords=cbind(columbus$X, columbus$Y))
gwer.diag(gwer.fitn)               
\donttest{
data(columbus, package="spData")
fit.elliptical <- elliptical(CRIME ~ INC, family = Student(df=3), data=columbus)
summary(fit.elliptical)
gwer.bw <- gwer.sel(CRIME ~ INC, data=columbus, family = Student(df=3),
                 coords=cbind(columbus$X, columbus$Y), method = 'aic')
gwer.fitt <- gwer(CRIME ~ INC, family = Student(df=3), bandwidth = gwer.bw, 
                 spdisp = TRUE, hatmatrix = TRUE, data=columbus, method = "gwer.fit",
                 coords=cbind(columbus$X, columbus$Y))
gwer.diag(gwer.fitt)  
}
}
\references{
Galea, M., Paula, G. A., and Cysneiros, F. J. A. (2005). On diagnostics in 
symmetrical nonlinear models. Statistics & Probability Letters, 73(4), 459-467.
\url{https://doi.org/10.1016/j.spl.2005.04.033}
}
\seealso{
\code{\link{elliptical}}
}
\keyword{Diagnostic}
\keyword{Elliptical}
\keyword{Geographically}
\keyword{Regression}
\keyword{Weighted}
\keyword{methods}
\keyword{models}
