% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.elliptical.R
\name{residuals.elliptical}
\alias{residuals.elliptical}
\title{Extract Model Residuals}
\usage{
\method{residuals}{elliptical}(object, type = c("stand", "pearson",
  "response"), ...)
}
\arguments{
\item{object}{fit object for elliptical regression model.}

\item{type}{an character string that indicates the type of residuals.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
Residuals extracted from the \code{object}.
}
\description{
residuals is a generic function which extracts model residuals from objects returned by modeling functions.
}
\examples{
data(luzdat)
y <- luzdat$y
x1 <- luzdat$x1 ; x1 <- factor(x1) ; x1 <- C(x1,treatment)
x2 <- luzdat$x2
x3 <- (luzdat$x2)^2
luz <- data.frame(y,x1,x2,x3)
elliptical.fitt <- elliptical(y ~ x1+x2+x3, family = Student(df=5)
,data=luz)
residuals(elliptical.fitt)
}
\references{
Galea, M., Paula, G. A., and Cysneiros, F. J. A. (2005). On diagnostics in 
symmetrical nonlinear models. Statistics & Probability Letters, 73(4), 459-467.
\url{https://doi.org/10.1016/j.spl.2005.04.033}
}
\seealso{
\code{\link{elliptical}}
}
\keyword{elliptical}
\keyword{residuals}
