\name{capture}
\alias{capture}
\alias{sprint}
\title{Capture printed output of an R expression in a string}
\description{ 
Capture printed output of an R expression in a string
}
\usage{
capture(expression, collapse = "\n")
sprint(x,...)
}
\arguments{
  \item{expression}{R expression whose output will be captured.}
  \item{collapse}{Character used to join output lines.  Defaults to
    "\\n".  Use \code{NULL} to return a vector of individual output lines.}
  \item{x}{Object to be printed}
  \item{...}{Optional parameters to be passed to \code{\link{print}} }
}
\details{
  The \code{capture} function uses \code{\link{sink}} to capture the
  printed results generated by \code{expression}. 

  The function \code{sprint} uses \code{capture} to redirect the
  results of calling \code{\link{print}} on an object to a string.
}
\value{
  A character string, or if \code{collapse==NULL} a vector of character
  strings containing the printed output from the R expression.
}
\section{WARNING}{R 1.7.0+ includes \code{capture.output}, which
  duplicates the functionality of \code{capture}.  Thus, \code{capture}
  is depreciated.}
\author{Gregory R. Warnes \email{greg@random-technologies-llc.com} }
\seealso{
  \code{\link[session]{texteval}},
  \code{\link{capture.output}}
}
\examples{

# capture the results of a loop
loop.text <- capture( for(i in 1:10) cat("i=",i,"\n") )
loop.text

# put regression summary results into a string
data(iris)
reg <- lm( Sepal.Length ~ Species, data=iris )
summary.text <- sprint( summary(reg) )
cat(summary.text)
}
\keyword{print}
\keyword{IO}
