% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete.R
\name{discretize}
\alias{discretize}
\alias{discretize.numeric}
\alias{discretize.list}
\alias{discretize.integer}
\alias{discretize.FitLandDF}
\title{Discretize Numeric Variable Into Categories}
\usage{
discretize(x, ...)

\method{discretize}{numeric}(x, nlevels, method = "equal", ...)

\method{discretize}{list}(x, nlevels, ...)

\method{discretize}{integer}(x, nlevels, ...)

\method{discretize}{FitLandDF}(x, nlevels, ...)
}
\arguments{
\item{x}{either a vector (\code{numeric} or \code{integer}) or \code{FitLandDF} object}

\item{...}{potential additional arguments, currently unnecessary}

\item{nlevels}{positive integer indicating number of discrete categories}

\item{method}{method by which to discretize; split into equal sections by
default (\code{"equal"} value for parameter)}
}
\value{
discretized form of \code{x}
}
\description{
Takes a numeric variable (could be of class \code{numeric} or \code{integer}) and
returns a discretized version, in which each element has been replaced by a
single integer between \code{1} and \code{nlevels}, inclusive.
}
\examples{

## discretize a numeric vector
vec <- 1:10
discretize(vec, nlevels = 5) # discretize into 5 categories
discretize(vec, 2)           # discretize into 2 categories

## discretize a fitness landscape
# create a 3x3x3 fitness landscape with values 1 through 27
fl_data <- array(1:27, dim = rep(3, 3))
my_fl <- fitscape::FitLandDF(fl_data)
discretize(my_fl, nlevels = 2) # discretize landscape into 2 categories
discretize(my_fl, 5)           # discretize landscape into 5 categories
}
