% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_data.R
\name{fmt_currency}
\alias{fmt_currency}
\title{Format values as currencies}
\usage{
fmt_currency(
  data,
  columns = everything(),
  rows = everything(),
  currency = "USD",
  use_subunits = TRUE,
  decimals = NULL,
  drop_trailing_dec_mark = TRUE,
  use_seps = TRUE,
  accounting = FALSE,
  scale_by = 1,
  suffixing = FALSE,
  pattern = "{x}",
  sep_mark = ",",
  dec_mark = ".",
  force_sign = FALSE,
  placement = "left",
  incl_space = FALSE,
  system = c("intl", "ind"),
  locale = NULL
)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{columns}{The columns to format. Can either be a series of column names
provided in \code{\link[=c]{c()}}, a vector of column indices, or a helper function
focused on selections. The select helper functions are: \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and
\code{\link[=everything]{everything()}}.}

\item{rows}{Optional rows to format. Providing \code{\link[=everything]{everything()}} (the
default) results in all rows in \code{columns} being formatted. Alternatively,
we can supply a vector of row captions within \code{\link[=c]{c()}}, a vector of row
indices, or a helper function focused on selections. The select helper
functions are: \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}},
\code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}. We can also use expressions
to filter down to the rows we need (e.g.,
\verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{currency}{The currency to use for the numeric value. This input can be
supplied as a 3-letter currency code (e.g., \code{"USD"} for U.S. Dollars,
\code{"EUR"} for the Euro currency). Use \code{\link[=info_currencies]{info_currencies()}} to get an
information table with all of the valid currency codes and examples of
each. Alternatively, we can provide a common currency name (e.g.,
\code{"dollar"}, \code{"pound"}, \code{"yen"}, etc.) to simplify the process. Use
\code{\link[=info_currencies]{info_currencies()}} with the \code{type == "symbol"} option to view an
information table with all of the supported currency symbol names along
with examples.

We can also use the \code{\link[=currency]{currency()}} helper function to specify a custom
currency, where the string could vary across output contexts. For example,
using \code{currency(html = "&fnof;", default = "f")} would give us a suitable
glyph for the Dutch guilder in an HTML output table, and it would simply be
the letter "f" in all other output contexts). Please note that \code{decimals}
will default to \code{2} when using the \code{\link[=currency]{currency()}} helper function.

If nothing is provided to \code{currency} then \code{"USD"} (U.S. dollars) will be
used.}

\item{use_subunits}{An option for whether the subunits portion of a currency
value should be displayed. By default, this is \code{TRUE}.}

\item{decimals}{An option to specify the exact number of decimal places to
use. The default number of decimal places is \code{2}.}

\item{drop_trailing_dec_mark}{A logical value that determines whether decimal
marks should always appear even if there are no decimal digits to display
after formatting (e.g, \code{23} becomes \code{23.}). The default for this is \code{TRUE},
which means that trailing decimal marks are not shown.}

\item{use_seps}{An option to use digit group separators. The type of digit
group separator is set by \code{sep_mark} and overridden if a locale ID is
provided to \code{locale}. This setting is \code{TRUE} by default.}

\item{accounting}{An option to use accounting style for values. With \code{FALSE}
(the default), negative values will be shown with a minus sign. Using
\code{accounting = TRUE} will put negative values in parentheses.}

\item{scale_by}{A value to scale the input. The default is \code{1.0}. All numeric
values will be multiplied by this value first before undergoing formatting.
This value will be ignored if using any of the \code{suffixing} options (i.e.,
where \code{suffixing} is not set to \code{FALSE}).}

\item{suffixing}{An option to scale and apply suffixes to larger numbers
(e.g., \code{1924000} can be transformed to \verb{1.92M}). This option can accept a
logical value, where \code{FALSE} (the default) will not perform this
transformation and \code{TRUE} will apply thousands (\code{K}), millions (\code{M}),
billions (\code{B}), and trillions (\code{T}) suffixes after automatic value scaling.
We can also specify which symbols to use for each of the value ranges by
using a character vector of the preferred symbols to replace the defaults
(e.g., \code{c("k", "Ml", "Bn", "Tr")}).

Including \code{NA} values in the vector will ensure that the particular range
will either not be included in the transformation (e.g, \code{c(NA, "M", "B", "T")} won't modify numbers in the thousands range) or the range will
inherit a previous suffix (e.g., with \code{c("K", "M", NA, "T")}, all numbers
in the range of millions and billions will be in terms of millions).

Any use of \code{suffixing} (where it is not set expressly as \code{FALSE}) means
that any value provided to \code{scale_by} will be ignored.

If using \code{system = "ind"} then the default suffix set provided by
\code{suffixing = TRUE} will be \code{c(NA, "L", "Cr")}. This doesn't apply suffixes
to the thousands range, but does express values in lakhs and crores.}

\item{pattern}{A formatting pattern that allows for decoration of the
formatted value. The value itself is represented by \code{{x}} and all other
characters are taken to be string literals.}

\item{sep_mark}{The mark to use as a separator between groups of digits
(e.g., using \code{sep_mark = ","} with \code{1000} would result in a formatted value
of \verb{1,000}).}

\item{dec_mark}{The character to use as a decimal mark (e.g., using \code{dec_mark = ","} with \code{0.152} would result in a formatted value of \verb{0,152}).}

\item{force_sign}{Should the positive sign be shown for positive values
(effectively showing a sign for all values except zero)? If so, use \code{TRUE}
for this option. The default is \code{FALSE}, where only negative numbers will
display a minus sign. This option is disregarded when using accounting
notation with \code{accounting = TRUE}.}

\item{placement}{The placement of the currency symbol. This can be either be
\code{left} (the default) or \code{right}.}

\item{incl_space}{An option for whether to include a space between the value
and the currency symbol. The default is to not introduce a space character.}

\item{system}{The numbering system to use. By default, this is the
international numbering system (\code{"intl"}) whereby grouping separators
(i.e., \code{sep_mark}) are separated by three digits. The alternative system,
the Indian numbering system (\code{"ind"}) uses grouping separators that
correspond to thousand, lakh, crore, and higher quantities.}

\item{locale}{An optional locale identifier that can be used for formatting
the value according the locale's rules. Examples include \code{"en"} for English
(United States) and \code{"fr"} for French (France). The use of a locale ID will
override any locale-specific values provided. We can use the
\code{\link[=info_locales]{info_locales()}} function as a useful reference for all of the locales that
are supported.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
With numeric values in a \strong{gt} table, we can perform currency-based
formatting. This function supports both automatic formatting with a
three-letter or numeric currency code. We can also specify a custom currency
that is formatted according to the output context with the \code{\link[=currency]{currency()}}
helper function. Numeric formatting facilitated through the use of a locale
ID. We have fine control over the conversion from numeric values to currency
values, where we could take advantage of the following options:
\itemize{
\item the currency: providing a currency code or common currency name will
procure the correct currency symbol and number of currency subunits; we could
also use the \code{\link[=currency]{currency()}} helper function to specify a custom currency
\item currency symbol placement: the currency symbol can be placed before
or after the values
\item decimals/subunits: choice of the number of decimal places, and a
choice of the decimal symbol, and an option on whether to include or exclude
the currency subunits (decimal portion)
\item negative values: choice of a negative sign or parentheses for values
less than zero
\item digit grouping separators: options to enable/disable digit separators
and provide a choice of separator symbol
\item scaling: we can choose to scale targeted values by a multiplier value
\item large-number suffixing: larger figures (thousands, millions, etc.) can
be autoscaled and decorated with the appropriate suffixes
\item pattern: option to use a text pattern for decoration of the formatted
currency values
\item locale-based formatting: providing a locale ID will result in
currency formatting specific to the chosen locale
}

We can use the \code{\link[=info_currencies]{info_currencies()}} function for a useful reference on all of
the possible inputs to the \code{currency} argument.
}
\section{Compatibility of formatting function with data values}{


The \code{fmt_currency()} formatting function is compatible with body cells that
are of the \code{"numeric"} or \code{"integer"} types. Any other types of body cells
are ignored during formatting. This is to say that cells of incompatible data
types may be targeted, but there will be no attempt to format them.
}

\section{Targeting cells with \code{columns} and \code{rows}}{


Targeting of values is done through \code{columns} and additionally by \code{rows} (if
nothing is provided for \code{rows} then entire columns are selected). The
\code{columns} argument allows us to target a subset of cells contained in the
resolved columns. We say resolved because aside from declaring column names
in \code{c()} (with bare column names or names in quotes) we can use
\strong{tidyselect}-style expressions. This can be as basic as supplying a select
helper like \code{starts_with()}, or, providing a more complex incantation like

\code{where(~ is.numeric(.x) && max(.x, na.rm = TRUE) > 1E6)}

which targets numeric columns that have a maximum value greater than
1,000,000 (excluding any \code{NA}s from consideration).

By default all columns and rows are selected (with the \code{everything()}
defaults). Cell values that are incompatible with a given formatting function
will be skipped over, like \code{character} values and numeric \verb{fmt_*()}
functions. So it's safe to select all columns with a particular formatting
function (only those values that can be formatted will be formatted), but,
you may not want that. One strategy is to format the bulk of cell values with
one formatting function and then constrain the columns for later passes with
other types of formatting (the last formatting done to a cell is what you get
in the final output).

Once the columns are targeted, we may also target the \code{rows} within those
columns. This can be done in a variety of ways. If a stub is present, then we
potentially have row identifiers. Those can be used much like column names in
the \code{columns}-targeting scenario. We can use simpler \strong{tidyselect}-style
expressions (the select helpers should work well here) and we can use quoted
row identifiers in \code{c()}. It's also possible to use row indices (e.g.,
\code{c(3, 5, 6)}) though these index values must correspond to the row numbers of
the input data (the indices won't necessarily match those of rearranged rows
if row groups are present). One more type of expression is possible, an
expression that takes column values (can involve any of the available columns
in the table) and returns a logical vector. This is nice if you want to base
formatting on values in the column or another column, or, you'd like to use a
more complex predicate expression.
}

\section{Adapting output to a specific \code{locale}}{


This formatting function can adapt outputs according to a provided \code{locale}
value. Examples include \code{"en"} for English (United States) and \code{"fr"} for
French (France). The use of a valid locale ID here means separator and
decimal marks will be correct for the given locale. Should any values be
provided in \code{sep_mark} or \code{dec_mark}, they will be overridden by the locale's
preferred values.

Note that a \code{locale} value provided here will override any global locale
setting performed in \code{\link[=gt]{gt()}}'s own \code{locale} argument (it is settable there as
a value received by all other functions that have a \code{locale} argument). As a
useful reference on which locales are supported, we can use the
\code{\link[=info_locales]{info_locales()}} function to view an info table.
}

\section{Examples}{


Use \code{\link{exibble}} to create a \strong{gt} table. Format the \code{currency} column to
have currency values in euros (\code{"EUR"}).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  gt() |>
  fmt_currency(
    columns = currency,
    currency = "EUR"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_currency_1.png" alt="This image of a table was generated from the first code example in the `fmt_currency()` help file." style="width:100\%;">
}}

Use \code{\link{exibble}} to create a \strong{gt} table. Keep only the \code{num} and \code{currency},
columns, then, format those columns using the \code{"CNY"} and \code{"GBP"} currencies.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  dplyr::select(num, currency) |>
  gt() |>
  fmt_currency(
    columns = num,
    currency = "CNY"
  ) |>
  fmt_currency(
    columns = currency,
    currency = "GBP"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_currency_2.png" alt="This image of a table was generated from the second code example in the `fmt_currency()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

3-8
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
The vector-formatting version of this function:
\code{\link[=vec_fmt_currency]{vec_fmt_currency()}}.

Other data formatting functions: 
\code{\link{data_color}()},
\code{\link{fmt_auto}()},
\code{\link{fmt_bins}()},
\code{\link{fmt_bytes}()},
\code{\link{fmt_datetime}()},
\code{\link{fmt_date}()},
\code{\link{fmt_duration}()},
\code{\link{fmt_engineering}()},
\code{\link{fmt_flag}()},
\code{\link{fmt_fraction}()},
\code{\link{fmt_image}()},
\code{\link{fmt_index}()},
\code{\link{fmt_integer}()},
\code{\link{fmt_markdown}()},
\code{\link{fmt_number}()},
\code{\link{fmt_partsper}()},
\code{\link{fmt_passthrough}()},
\code{\link{fmt_percent}()},
\code{\link{fmt_roman}()},
\code{\link{fmt_scientific}()},
\code{\link{fmt_spelled_num}()},
\code{\link{fmt_time}()},
\code{\link{fmt_url}()},
\code{\link{fmt}()},
\code{\link{sub_large_vals}()},
\code{\link{sub_missing}()},
\code{\link{sub_small_vals}()},
\code{\link{sub_values}()},
\code{\link{sub_zero}()}
}
\concept{data formatting functions}
