% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_data.R
\name{fmt_partsper}
\alias{fmt_partsper}
\title{Format values as parts-per quantities}
\usage{
fmt_partsper(
  data,
  columns,
  rows = everything(),
  to_units = c("per-mille", "per-myriad", "pcm", "ppm", "ppb", "ppt", "ppq"),
  symbol = "auto",
  decimals = 2,
  drop_trailing_zeros = FALSE,
  drop_trailing_dec_mark = TRUE,
  scale_values = TRUE,
  use_seps = TRUE,
  pattern = "{x}",
  sep_mark = ",",
  dec_mark = ".",
  force_sign = FALSE,
  incl_space = "auto",
  system = c("intl", "ind"),
  locale = NULL
)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{columns}{The columns to format. Can either be a series of column names
provided in \code{\link[=c]{c()}}, a vector of column indices, or a helper function
focused on selections. The select helper functions are: \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and
\code{\link[=everything]{everything()}}.}

\item{rows}{Optional rows to format. Providing \code{\link[=everything]{everything()}} (the
default) results in all rows in \code{columns} being formatted. Alternatively,
we can supply a vector of row captions within \code{\link[=c]{c()}}, a vector of row
indices, or a helper function focused on selections. The select helper
functions are: \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}},
\code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}. We can also use expressions
to filter down to the rows we need (e.g.,
\verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{to_units}{A keyword that signifies the desired output quantity. This
can be any from the following set: \code{"per-mille"}, \code{"per-myriad"}, \code{"pcm"},
\code{"ppm"}, \code{"ppb"}, \code{"ppt"}, or \code{"ppq"}.}

\item{symbol}{The symbol/units to use for the quantity. By default, this is
set to \code{"auto"} and \strong{gt} will choose the appropriate symbol based on the
\code{to_units} keyword and the output context. However, this can be changed by
supplying a string (e.g, using \code{symbol = "ppbV"} when \code{to_units = "ppb"}).}

\item{decimals}{An option to specify the exact number of decimal places to
use. The default number of decimal places is \code{2}.}

\item{drop_trailing_zeros}{A logical value that allows for removal of
trailing zeros (those redundant zeros after the decimal mark).}

\item{drop_trailing_dec_mark}{A logical value that determines whether decimal
marks should always appear even if there are no decimal digits to display
after formatting (e.g, \code{23} becomes \code{23.}). The default for this is \code{TRUE},
which means that trailing decimal marks are not shown.}

\item{scale_values}{Should the values be scaled through multiplication
according to the keyword set in \code{to_units}? By default this is \code{TRUE} since
the expectation is that normally values are proportions. Setting to \code{FALSE}
signifies that the values are already scaled and require only the
appropriate symbol/units when formatted.}

\item{use_seps}{An option to use digit group separators. The type of digit
group separator is set by \code{sep_mark} and overridden if a locale ID is
provided to \code{locale}. This setting is \code{TRUE} by default.}

\item{pattern}{A formatting pattern that allows for decoration of the
formatted value. The value itself is represented by \code{{x}} and all other
characters are taken to be string literals.}

\item{sep_mark}{The mark to use as a separator between groups of digits
(e.g., using \code{sep_mark = ","} with \code{1000} would result in a formatted value
of \verb{1,000}).}

\item{dec_mark}{The character to use as a decimal mark (e.g., using \code{dec_mark = ","} with \code{0.152} would result in a formatted value of \verb{0,152}).}

\item{force_sign}{Should the positive sign be shown for positive values
(effectively showing a sign for all values except zero)? If so, use \code{TRUE}
for this option. The default is \code{FALSE}, where only negative numbers will
display a minus sign. This option is disregarded when using accounting
notation with \code{accounting = TRUE}.}

\item{incl_space}{An option for whether to include a space between the value
and the symbol/units. The default is \code{"auto"} which provides spacing
dependent on the mark itself. This can be directly controlled by using
either \code{TRUE} or \code{FALSE}.}

\item{system}{The numbering system to use. By default, this is the
international numbering system (\code{"intl"}) whereby grouping separators
(i.e., \code{sep_mark}) are separated by three digits. The alternative system,
the Indian numbering system (\code{"ind"}) uses grouping separators that
correspond to thousand, lakh, crore, and higher quantities.}

\item{locale}{An optional locale ID that can be used for formatting the value
according the locale's rules. Examples include \code{"en"} for English (United
States) and \code{"fr"} for French (France). The use of a valid locale ID will
override any values provided in \code{sep_mark} and \code{dec_mark}. We can use the
\code{\link[=info_locales]{info_locales()}} function as a useful reference for all of the locales that
are supported. Any \code{locale} value provided here will override any global
locale setting performed in \code{\link[=gt]{gt()}}'s own \code{locale} argument.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
With numeric values in a \strong{gt} table we can format the values so that they
are rendered as \emph{per mille}, \emph{ppm}, \emph{ppb}, etc., quantities. The following
list of keywords (with associated naming and scaling factors) is available to
use within \code{fmt_partsper()}:
\itemize{
\item \code{"per-mille"}: Per mille, (1 part in \verb{1,000})
\item \code{"per-myriad"}: Per myriad, (1 part in \verb{10,000})
\item \code{"pcm"}: Per cent mille (1 part in \verb{100,000})
\item \code{"ppm"}: Parts per million, (1 part in \verb{1,000,000})
\item \code{"ppb"}: Parts per billion, (1 part in \verb{1,000,000,000})
\item \code{"ppt"}: Parts per trillion, (1 part in \verb{1,000,000,000,000})
\item \code{"ppq"}: Parts per quadrillion, (1 part in \verb{1,000,000,000,000,000})
}

The function provides a lot of formatting control and we can use the
following options:
\itemize{
\item custom symbol/units: we can override the automatic symbol or units display
with our own choice as the situation warrants
\item decimals: choice of the number of decimal places, option to drop
trailing zeros, and a choice of the decimal symbol
\item digit grouping separators: options to enable/disable digit separators
and provide a choice of separator symbol
\item value scaling toggle: choose to disable automatic value scaling in the
situation that values are already scaled coming in (and just require the
appropriate symbol or unit display)
\item pattern: option to use a text pattern for decoration of the formatted
values
\item locale-based formatting: providing a locale ID will result in number
formatting specific to the chosen locale
}
}
\section{Targeting the values to be formatted}{


Targeting of values is done through \code{columns} and additionally by \code{rows} (if
nothing is provided for \code{rows} then entire columns are selected). Conditional
formatting is possible by providing a conditional expression to the \code{rows}
argument. See the \emph{Arguments} section for more information on this.
}

\section{Examples}{


Create a tibble of small numeric values and generate a \strong{gt} table. Format
the \code{a} column to appear in scientific notation with \code{\link[=fmt_scientific]{fmt_scientific()}} and
format the \code{b} column as \emph{per mille} values with \code{fmt_partsper()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::tibble(x = 0:-5, a = 10^(0:-5), b = a) \%>\%
  gt(rowname_col = "x") \%>\%
  fmt_scientific(a, decimals = 0) \%>\%
  fmt_partsper(
    columns = b,
    to_units = "per-mille"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_partsper_1.png" alt="This image of a table was generated from the first code example in the `fmt_partsper()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

3-6
}

\seealso{
Other data formatting functions: 
\code{\link{data_color}()},
\code{\link{fmt_bytes}()},
\code{\link{fmt_currency}()},
\code{\link{fmt_datetime}()},
\code{\link{fmt_date}()},
\code{\link{fmt_duration}()},
\code{\link{fmt_engineering}()},
\code{\link{fmt_fraction}()},
\code{\link{fmt_integer}()},
\code{\link{fmt_markdown}()},
\code{\link{fmt_number}()},
\code{\link{fmt_passthrough}()},
\code{\link{fmt_percent}()},
\code{\link{fmt_roman}()},
\code{\link{fmt_scientific}()},
\code{\link{fmt_time}()},
\code{\link{fmt}()},
\code{\link{sub_large_vals}()},
\code{\link{sub_missing}()},
\code{\link{sub_small_vals}()},
\code{\link{sub_values}()},
\code{\link{sub_zero}()},
\code{\link{text_transform}()}
}
\concept{data formatting functions}
