% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_kappa_t_exact}
\alias{gsw_kappa_t_exact}
\title{Isentropic compressibility of seawater}
\usage{
gsw_kappa_t_exact(SA, t, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{t}{in-situ temperature (ITS-90) [ deg C ]}

\item{p}{sea pressure [ dbar ]}
}
\value{
isentropic compressibility [ 1/Pa ] (not 1/dbar)
}
\description{
Isentropic compressibility of seawater
}
\examples{
gsw_kappa_t_exact(34.7118, 28.7856, 10) # 4.11245799180373e-10
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_kappa_t_exact.html}
}
\seealso{
\code{\link{gsw_kappa}} is an analogue in terms of Conservative Temperature
}

