% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_C_from_SP}
\alias{gsw_C_from_SP}
\title{Electrical conductivity from Practical Salinity}
\usage{
gsw_C_from_SP(SP, t, p)
}
\arguments{
\item{SP}{Practical Salinity (PSS-78) [ unitless ]}

\item{t}{in-situ temperature (ITS-90) [ deg C ]}

\item{p}{sea pressure [ dbar ]}
}
\value{
electrical conductivity [ mS/cm ]
}
\description{
Note: the return value is not conductivity ratio, but rather
conductivity itself, in mS/cm.  To convert to conductivity
ratio, divide by gsw_C_from_SP(35, 15, 0).
}
\examples{
gsw_C_from_SP(34.5487, 28.7856, 10) # 56.412599581571186
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_C_from_SP.html}
}
\seealso{
\code{\link{gsw_SP_from_C}} does the reverse.
}

