% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locale.R
\name{gr_set_locale}
\alias{gr_set_locale}
\title{Set the language that is used for plotting}
\usage{
gr_set_locale(locale = "EN")
}
\arguments{
\item{locale}{Character string locale. Currently only English (\code{'EN'}), Russian (\code{'RU'}) and Ukrainian (\code{'UA'}) locales are supported. More locales can be requested at issue on GitHub. Defaults to \code{'EN'}.}
}
\value{
No return value, called for side effects
}
\description{
Run this function once at the beginning of the session. All plots will be labeled using the selected language.
}
\details{
Note to Linux users: the desired locale may not be installed on the system. A list of available locales can be obtained in bash terminal:

\code{locale -a}

Russian locale is \code{ru_RU.UTF-8}, and Ukrainian locale is \code{uk_UA.UTF-8}. If absent in the list, then install the desired locales by:

\verb{sudo locale-gen ru_RU.UTF-8}

\verb{sudo locale-gen uk_UA.UTF-8}

\verb{sudo update-locale}

Then restart R session, and localization should work as expected.
}
\examples{
library(grwat)

data(spas) # example Spas-Zagorye data is included with grwat package

# separate
sep = gr_separate(spas, params = gr_get_params(reg = 'center'))

# Default is English
gr_plot_sep(sep, 1978) 

# Change to Russian
gr_set_locale('RU')
gr_plot_sep(sep, 1978)

# Change to Ukrainian
gr_set_locale('UA')
gr_plot_sep(sep, 1978)

# Restore English
gr_set_locale('EN')
gr_plot_sep(sep, 1978) 

}
