% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GenerateSyntheticAnova.R
\name{GenerateSyntheticAnova}
\alias{GenerateSyntheticAnova}
\title{Generate synthetic functional ANOVA dataset}
\usage{
GenerateSyntheticAnova(st.dev = 10, n.replicates = 5)
}
\arguments{
\item{st.dev}{The standard deviation of the error.}

\item{n.replicates}{The number of replicates for each factor combination.}
}
\value{
A list containing the data without noise, the data with noise, and the
design matrix.
}
\description{
This function generates a synthetic 3-factor functional ANOVA dataset.
}
\examples{
data <- GenerateSyntheticAnova(st.dev = 5, n.replicates = 10)
ix <- 1
plot(data$clean.Y[ix, ], type = "l", col = "red", ylab = "")
lines(data$noisy.Y[ix, ], col = "blue")
}

