% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_lm.R
\name{grouped_lm}
\alias{grouped_lm}
\title{Running linear model (\code{lm}) across multiple grouping variables.}
\usage{
grouped_lm(
  data,
  grouping.vars,
  ...,
  output = "tidy",
  tidy.args = list(conf.int = TRUE, conf.level = 0.95),
  augment.args = list()
)
}
\arguments{
\item{data}{Dataframe (or tibble) from which variables are to be taken.}

\item{grouping.vars}{Grouping variables.}

\item{...}{Additional arguments to \code{broom::tidy}, \code{broom::glance}, or
\code{broom::augment} S3 method.}

\item{output}{A character describing what output is expected. Two possible
options: \code{"tidy"} (default), which will return the results, or \code{"glance"},
which will return model summaries.}

\item{tidy.args}{A list of arguments to be used in the relevant \code{S3} method.}

\item{augment.args}{A list of arguments to be used in the relevant \code{S3} method.}
}
\value{
A tibble dataframe with tidy results from linear model.
}
\description{
Running linear model (\code{lm}) across multiple grouping variables.
}
\examples{

# loading needed libraries
library(ggplot2)

# getting tidy output of results
grouped_lm(
  data = mtcars,
  grouping.vars = cyl,
  formula = mpg ~ am * wt,
  output = "tidy"
)

# getting model summaries
# diamonds dataset from ggplot2
grouped_lm(
  data = diamonds,
  grouping.vars = c(cut, color),
  formula = price ~ carat * clarity,
  output = "glance"
)
}
\seealso{
\code{\link{grouped_slr}}, \code{\link{grouped_tidy}}
}
\author{
Indrajeet Patil
}
