% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_wilcox.R
\name{grouped_wilcox}
\alias{grouped_wilcox}
\title{Function to run two-sample Wilcoxon tests on multiple variables across
multiple grouping variables.}
\usage{
grouped_wilcox(data, dep.vars, indep.vars, grouping.vars, paired = FALSE,
  correct = TRUE)
}
\arguments{
\item{data}{Dataframe from which variables are to be taken.}

\item{dep.vars}{List dependent variables for a two-sample Wilcoxon tests (\code{y}
in \code{y ~ x}).}

\item{indep.vars}{List independent variables for a two-sample Wilcoxon tests
(\code{x} in \code{y ~ x}).}

\item{grouping.vars}{List of grouping variables.}

\item{paired}{A logical indicating whether you want a paired two-sample
Wilcoxon tests (Default: \code{paired = FALSE}).}

\item{correct}{A logical indicating whether to apply continuity correction in
the normal approximation for the p-value (Default: \code{correct = TRUE}).}
}
\value{
A tibble dataframe with tidy results from two-sample Wilcoxon tests
analyses.
}
\description{
Function to run two-sample Wilcoxon tests on multiple variables across
multiple grouping variables.
}
\examples{

# only with one grouping variable
groupedstats::grouped_wilcox(
  data = dplyr::filter(.data = ggplot2::diamonds, color == "E" | color == "J"),
  dep.vars = depth:price,
  indep.vars = color,
  grouping.vars = clarity,
  paired = FALSE
)

}
\author{
Indrajeet Patil
}
