% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groundhog.library.R
\name{groundhog.library}
\alias{groundhog.library}
\title{Install & load CRAN, GitHub, and GitLab packages as current on given date}
\usage{
groundhog.library(
  pkg,
  date,
  quiet.install = TRUE,
  include.suggests = FALSE,
  ignore.deps = c(),
  force.source = FALSE,
  force.install = FALSE,
  force.source.main = FALSE,
  force.install.main = FALSE,
  tolerate.R.version = "",
  cores = -1
)
}
\arguments{
\item{pkg}{character string or vector with name of package(s) to load/install.}

\item{date}{character string  (yyyy-mm-dd), or date value, with the date which
determines the version of the package, and all dependencies, to be loaded
(and installed if needed). The most recent date accepted is 2 days prior
to when the code is executed.}

\item{quiet.install}{logical, defaults to \code{TRUE}. When set to \code{FALSE}, displays
output generated by \code{install.packages()} when installing from source}

\item{include.suggests}{logical, defaults to \code{FALSE}. When set to \code{TRUE},
loads dependencies classified in the DESCRIPTION file as \code{suggested}.}

\item{ignore.deps}{an optional character vector containing dependencies which
are already loaded in the R session, and create a conflict with a needed
dependency for the package being loaded (mismatch of version), but which should be ignored
and groundhog.library() should proceed tolerating the conflict.}

\item{force.source}{logical (defaults to \code{FALSE}). When set to \code{TRUE}, if the requested package,
or its dependencies, needs to be installed, they will be installed from source
(much slower than from binaries).}

\item{force.install}{logical (defaults to \code{FALSE}). When set to \code{TRUE},
will re-install the requested packages and
their dependencies even if they are already installed.}

\item{force.source.main}{logical (defaults to \code{FALSE}). When set to \code{TRUE}, if the
requested package needs to be installed it will be installed from source
(but dependencies are installed from binaries if needed and available).}

\item{force.install.main}{logical (defaults to \code{FALSE}). When set to \code{TRUE},
will re-install the requested packages even
if they are already installed (but dependencies will not be re-installed).}

\item{tolerate.R.version}{optional character string containing an R version
which \code{groundhog.library()} will not throw an error for using, even if the
date entered corresponds to a more recent major R release.}

\item{cores}{Integer. The maximum number of cores to use during parallel installation
of source packages. The default, -1, uses the total number of cores available minus 1.
Setting \code{core}=1 leads to installing source packages, and also to downloading binaries,
sequentially. When installation fails, you may want to try cores=1}
}
\description{
Load requested package(s)  as current on a requested date. If the needed version
of a package, or its dependencies, is not already installed, groundhog automatically
installs it. \code{groundhog.library()} thus substitutes both \code{library()}
and \code{install.packages()}. There is no change in setup or configuration parameters
needed to start using groundhog; simply edit your script going between
\code{library()} and \code{groundhog.library()} as needed. Groundhog often installs/uninstalls
packages in the default personal library. These changes can be reversed in a few seconds,
with \code{\link[=restore.library]{restore.library()}}
}
\details{
For more information about groundhog check out \href{http://groundhogr.com}{groundhogr.com}
}
\examples{
\dontrun{
groundhog.library("magrittr", "2022-04-15")

pkgs <- c('pwr','metafor')
groundhog.library(pkgs, "2022-04-15")

# When running an existing  script that relied on `library()` to load packages,
# you can wrap the library calls in double-quotes, loading the packages with 
# groundhog:

  groundhog.library(
       "
        library('pwr')
        library('metafor')
        library('tidyr')
        library('rio')
        library('this.path')
       "
       ,'2022-04-01')

#Allow using R 3.6.3 despite entering a date that corresponds to R >=4.0.0
  groundhog.library('rio', '2022-04-11', tolerate.R.version='3.6.3')

}

}
