% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_effect.R
\name{estimate_average_effect}
\alias{estimate_average_effect}
\title{Estimate average treatment effects using a causal forest}
\usage{
estimate_average_effect(forest, target.sample = c("all", "treated",
  "control"), method = c("AIPW", "TMLE"))
}
\arguments{
\item{forest}{The trained forest.}

\item{target.sample}{Which sample to aggregate treatment effects over.}

\item{method}{Method used for doubly robust inference. Can be either
augmented inverse-propensity weighting (AIPW), or
targeted maximum likelihood estimation (TMLE).}
}
\value{
An estimate of the average effect, along with standard error.
}
\description{
Gets estimates of one of the following
}
\details{
The (conditional) average treatment effect (target.sample = all):
  sum_{i = 1}^n E[Y(1) - Y(0) | X = Xi] / n
The (conditional) average treatment effect on the treated (target.sample = treated):
  sum_{Wi = 1} E[Y(1) - Y(0) | X = Xi] / |{i : Wi = 1}|
The (conditional) average treatment effect on the controls (target.sample = control):
  sum_{Wi = 0} E[Y(1) - Y(0) | X = Xi] / |{i : Wi = 0}|
}
\examples{
\dontrun{
# Train a causal forest.
n = 50; p = 10
X = matrix(rnorm(n*p), n, p)
W = rbinom(n, 1, 0.5)
Y = pmax(X[,1], 0) * W + X[,2] + pmin(X[,3], 0) + rnorm(n)
c.forest = causal_forest(X, Y, W)

# Predict using the forest.
X.test = matrix(0, 101, p)
X.test[,1] = seq(-2, 2, length.out = 101)
c.pred = predict(c.forest, X.test)
# Estimate the conditional average treatment effect on the full sample (CATE).
estimate_average_effect(c.forest, target.sample = "all")

# Estimate the conditional average treatment effect on the treated sample (CATT).
# We don't expect much difference between the CATE and the CATT in this example,
# since treatment assignment was randomized.
estimate_average_effect(c.forest, target.sample = "treated")
}

}
