% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_treatment_effect.R
\name{average_treatment_effect}
\alias{average_treatment_effect}
\title{Estimate average treatment effects using a causal forest}
\usage{
average_treatment_effect(forest, target.sample = c("all", "treated",
  "control", "overlap"), method = c("AIPW", "TMLE"), subset = NULL)
}
\arguments{
\item{forest}{The trained forest.}

\item{target.sample}{Which sample to aggregate treatment effects over.}

\item{method}{Method used for doubly robust inference. Can be either
augmented inverse-propensity weighting (AIPW), or
targeted maximum likelihood estimation (TMLE).}

\item{subset}{Specifies subset of the training examples over which we
estimate the ATE. WARNING: For valid statistical performance,
the subset should be defined only using features Xi, not using
the treatment Wi or the outcome Yi.}
}
\value{
An estimate of the average treatment effect, along with standard error.
}
\description{
Gets estimates of one of the following.
\itemize{
  \item The (conditional) average treatment effect (target.sample = all):
  sum_{i = 1}^n E[Y(1) - Y(0) | X = Xi] / n
  \item The (conditional) average treatment effect on the treated (target.sample = treated):
  sum_{Wi = 1} E[Y(1) - Y(0) | X = Xi] / |{i : Wi = 1}|
  \item The (conditional) average treatment effect on the controls (target.sample = control):
  sum_{Wi = 0} E[Y(1) - Y(0) | X = Xi] / |{i : Wi = 0}|
  \item The overlap-weighted (conditional) average treatment effect
  sum_{i = 1}^n e(Xi) (1 - e(Xi)) E[Y(1) - Y(0) | X = Xi] / sum_{i = 1}^n e(Xi) (1 - e(Xi)),
  where e(x) = P[Wi = 1 | Xi = x].
}
This last estimand is recommended by Li, Morgan, and Zaslavsky (JASA, 2017)
in case of poor overlap (i.e., when the propensities e(x) may be very close
to 0 or 1), as it doesn't involve dividing by estimated propensities.
}
\examples{
\dontrun{
# Train a causal forest.
n = 50; p = 10
X = matrix(rnorm(n*p), n, p)
W = rbinom(n, 1, 0.5)
Y = pmax(X[,1], 0) * W + X[,2] + pmin(X[,3], 0) + rnorm(n)
c.forest = causal_forest(X, Y, W)

# Predict using the forest.
X.test = matrix(0, 101, p)
X.test[,1] = seq(-2, 2, length.out = 101)
c.pred = predict(c.forest, X.test)
# Estimate the conditional average treatment effect on the full sample (CATE).
average_treatment_effect(c.forest, target.sample = "all")

# Estimate the conditional average treatment effect on the treated sample (CATT).
# We don't expect much difference between the CATE and the CATT in this example,
# since treatment assignment was randomized.
average_treatment_effect(c.forest, target.sample = "treated")

# Estimate the conditional average treatment effect on samples with positive X[,1].
average_treatment_effect(c.forest, target.sample = "all", X[,1] > 0)
}

}
