% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spread.R
\name{spread}
\alias{spread}
\title{Construct scatterplot / boxplots for the data}
\usage{
spread(data, histograms = FALSE, log = FALSE, ...)
}
\arguments{
\item{data}{Either matrix or data frame with the data.}

\item{histograms}{If \code{TRUE}, then the histograms and barplots are produced on
the diagonal of the matrix. Otherwise the names of the variables are written there.}

\item{log}{If \code{TRUE}, then the logarithms of all numerical variables are taken.}

\item{...}{Other parameters passed to the plot function. Currently only "main"
parameter is accepted.}
}
\value{
Function does not return anything. It just plots things.
}
\description{
Function constructs the plots depending on the types of variables in the provided
matrix / data frame.
}
\details{
If both variables are in metric scale, then the classical scatterplot is constructed.
If one of them is either integer (up to 10 values) or categorical (aka 'factor'),
then boxplots (with grey dots corresponding to mean values) are constructed. Finally,
for the two categorical variables the tableplot is returned (see
\link[greybox]{tableplot} function for the details). All of this is packed in a matrix.

See details in the vignette "Marketing analytics with greybox":
\code{vignette("maUsingGreybox","greybox")}
}
\examples{

### Simple example
spread(mtcars)
spread(mtcars,log=TRUE)

}
\seealso{
\code{\link[graphics]{plot}, \link[base]{table}, \link[greybox]{tableplot}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{graph}
\keyword{plots}
