% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/association.R
\name{association}
\alias{association}
\alias{assoc}
\title{Measures of association}
\usage{
association(x, y = NULL)

assoc(x, y = NULL)
}
\arguments{
\item{x}{Either data.frame or a matrix}

\item{y}{The numerical variable.}
}
\value{
The following list of values is returned:
\itemize{
\item{value}{Matrix of the coefficients of association;}
\item{p.value}{The p-values for the parameters;}
\item{type}{The matrix of the types of measures of association.}
}
}
\description{
Function returns the matrix of measures of association for different types of
variables.
}
\details{
The function looks at the types of the variables and calculates different
measures depending on the result:
\itemize{
\item If both variables are numeric, then Pearson's correlation is calculated;
\item If both variables are categorical, then Cramer's V is calculated;
\item Finally, if one of the variables is categorical, and the other is numeric,
then multiple correlation is returned.
}
After that the measures are wrapped up in a matrix.

Function also calculates the p-values associated with the respective measures
(see the return).

\code{assoc()} is just a short name for the \code{association{}}.
}
\examples{

association(mtcars)

}
\seealso{
\code{\link[base]{table}, \link[greybox]{tableplot}, \link[greybox]{spread},
\link[greybox]{cramer}, \link[greybox]{mcor}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{htest}
